<!DOCTYPE html>
<html lang="en" class="overflow-x-hidden scroll-smooth group" data-mode="light" dir="ltr">

<head>

    <meta charset="utf-8">
    <title>East Java running Fest</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta content="Minimal Admin & Dashboard Template" name="description">
    <meta content="subjersey" name="author">
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(URL::to('assets/images/EJR-Logo-light_icon.png')); ?>">
    <!-- Layout config Js -->
    <script src="<?php echo e(URL::to('assets/js/layout.js')); ?>"></script>
    <!-- Icons CSS -->

    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet"> -->

    <!-- StarCode CSS -->
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
    

  <link rel="stylesheet" href="<?php echo e(URL::to('assets/css/starcode2.css')); ?>">
</head>

<body class="text-base bg-white text-body font-public dark:text-zink-50 dark:bg-zink-800">

    <nav class="fixed inset-x-0 top-0 z-50 flex items-center justify-center h-20 py-3 [&.is-sticky]:bg-white dark:[&.is-sticky]:bg-zink-700 border-b border-slate-200 dark:border-zink-500 [&.is-sticky]:shadow-lg [&.is-sticky]:shadow-slate-200/25 dark:[&.is-sticky]:shadow-zink-500/30 navbar" id="navbar">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto flex items-center self-center w-full">
            <div class="shrink-0">
                <a href="<?php echo e(URL::to('/')); ?>">
                    <img src="assets/images/EJR-Logo-light.png" alt="" class="block h-14 dark:hidden">
                    <img src="assets/images/EJR-Logo-light.png" alt="" class="hidden h-14 dark:block">
                </a>
            </div>
            <div class="mx-auto">
                <ul id="navbar7" class="absolute inset-x-0 z-20 items-center hidden py-3 bg-white shadow-lg dark:bg-zink-600 dark:md:bg-transparent md:z-0 navbar-menu rounded-b-md md:shadow-none md:flex top-full ltr:ml-auto rtl:mr-auto md:relative md:bg-transparent md:rounded-none md:top-auto md:py-0">
                    <li>
                        <a href="#home" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500 active">Home</a>
                    </li>
                    <li>
                        <a href="#features" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Our Event</a>
                    </li>
                   
                    <li>
                        <a href="#pricing" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Kategori Lari</a>
                    </li>
                     <li>
                        <a href="<?php echo e(URL::to('/story')); ?>" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Our Story</a>
                    </li>
                    <li>
                        <a href="#contact" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Kontak</a>
                    </li>
                    <li>
                        <a href="<?php echo e(URL::to('/peserta')); ?>" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Peserta</a>
                    </li>
                    <li>
                    <a href="<?php echo e(URL::to('/hasil_bwi')); ?>" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Race Result Banyuwangi</a>
                    </li>
                    <li>
                    <a href="<?php echo e(URL::to('https://my.raceresult.com/328268/live')); ?>" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Race Result Kediri</a>
                    </li>
                </li>
            </div>
            <div class="flex gap-2">
                <div class="ltr:ml-auto rtl:mr-auto md:hidden navbar-toggale-button">
                    <button type="button" class="flex items-center  justify-center size-[37.5px] p-0 text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20"><i data-lucide="menu"></i></button>
                </div>
                <div class="shrink-0">
                        <a href="<?php echo e(URL::to('/lokasi')); ?>" type="button" class="text-white btn bg-sky-500 border-sky-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">
                        <span class="align-middle">Registrasi</span>
                        </a>
                   
                    <!-- <?php if($bukaBW): ?>
                        <a href="<?php echo e(URL::to('/banyuwangi')); ?>" type="button" class="text-white btn bg-sky-500 border-sky-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">
                        <span class="align-middle">Registrasi</span>
                        </a>
                        <?php elseif($bukaKD): ?>
                         <a href="<?php echo e(URL::to('/kediri')); ?>" type="button" class="text-white btn bg-sky-500 border-sky-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">
                            <span class="align-middle">Registrasi</span>
                        </a>
                        <?php elseif($bukaMN): ?>
                         <a href="<?php echo e(URL::to('/madiun')); ?>" type="button" class="text-white btn bg-sky-500 border-sky-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">
                            <span class="align-middle">Registrasi</span>
                        </a>
                        <?php elseif($bukaSB): ?>
                         <a href="<?php echo e(URL::to('/surabaya')); ?>" type="button" class="text-white btn bg-sky-500 border-sky-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">
                            <span class="align-middle">Registrasi</span>
                        </a>
                    <?php else: ?>
                        <a href="" type="button" class="text-white btn bg-sky-500 border-sky-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">
                            <span class="align-middle">Registrasi</span>
                        </a>

                    <?php endif; ?> -->
                </div>
                
            </div>
        </div>
    </nav>
 
<!-- disini  carousel-->



<section class="relative py-20 " id="feedback">
        <div class="container">
          
            <!-- Swiper -->
            <div class=" swiper feedback-slider">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="p-1 text-center" data-aos="fade-up" data-aos-easing="linear">
                            <div class="mx-auto">
                                <div id="image-container">
                                    <!-- <img src="assets/images/benner/BANNER-WEB-Baru-02.png" alt="" class="size-31"> -->
                            
                                </div>
                            </div>    
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="p-1 text-center" data-aos="fade-up" data-aos-easing="linear">
							<div class="mx-auto">
								<div id="image-container2">
									<!-- <img src="assets/images/benner/BANNER-WEB-Baru-01.png" alt="" class="size-21"> -->
								</div>
							</div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="p-1 text-center" data-aos="fade-up" data-aos-easing="linear">
							<div class="mx-auto">
								<div id="image-container3">
									
								</div>
							</div>
                        </div>
                    </div> 
                    <div class="swiper-slide">
                        <div class="p-1 text-center" data-aos="fade-up" data-aos-easing="linear">
							<div class="mx-auto">
								<div id="image-container4">
									
								</div>
							</div>
                        </div>
                    </div>    
                    <!-- <div class="swiper-slide">
                        <div class="p-1 text-center" data-aos="fade-up" data-aos-easing="linear">
                            <div class="mx-auto">
                                <img src="assets/images/benner/BANNER-WEB-Baru-02.png" alt="" class="size-21">
                            </div>
                            
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="swiper-slide">
                            <div class="p-1 text-center" data-aos="fade-up" data-aos-easing="linear">
                                <div class="mx-auto">
                                    <img src="assets/images/benner/BANNER-WEB-Baru-01.png" alt="" class="size-21">
                                </div>
                                
                            </div>
                        </div>
                    </div> -->
                </div><br><br>
                <div class="swiper-pagination"></div>
            </div>
        </div><!--end container-->
    </section><!--end -->



<!-- sampai sini -->
    <section class="relative pb-36 pt-24" id="home">
        <div class=" border-t-slate-300 dark:border-t-zink-500 border-l-slate-300 dark:border-l-zink-500 border-r-slate-700 dark:border-r-zink-400 border-b-slate-700 dark:border-b-zink-400 -bottom-[250px] rounded-full ltr:right-40 rtl:left-40 z-10 hidden lg:block"></div>
        <!-- <div class=" border border-dashed size-[700px] border-t-slate-300 dark:border-t-zink-500 border-l-slate-300 dark:border-l-zink-500 border-r-slate-700 dark:border-r-zink-400 border-b-slate-700 dark:border-b-zink-400 -bottom-[350px] rounded-full ltr:right-16 rtl:left-16 z-10 hidden 2xl:block"></div> -->
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="grid grid-cols-12 2xl:grid-cols-2">
                <div class="col-span-12 lg:col-span-7 2xl:col-span-1">
                    <h1 class="mb-8 !leading-relaxed md:text-5xl">East Java Running Fest <span class="relative inline-block px-2 mx-2 before:block before:absolute before:-inset-1 before:-skew-y-6 before:bg-sky-50 dark:before:bg-sky-500/20 before:rounded-md before:backdrop-blur-xl"><span class="relative text-sky-500">EJRF</span></span></h1>
                    <p class="mb-6 text-lg text-slate-500 dark:text-zink-200">EJRF event olahraga lari terbesar yang melibatkan empat kota besar di Jawa Timur: Banyuwangi, Madiun, Kediri, dan Surabaya. Mengusung semangat kebersamaan dan gaya hidup sehat, event ini menjadi ajang olahraga yang tidak hanya menantang fisik, tetapi juga memperkenalkan keindahan alam dan budaya unik setiap kota yang dilalui. Dengan berbagai kategori lomba, EJRF menyasar peserta dari berbagai usia dan level kemampuan, mulai dari pelari profesional hingga pemula yang ingin mencoba tantangan lari.</p>
                    <div class="flex items-center gap-2">
                        <!-- <button type="button" class="py-2.5 px-6 text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20"><i data-lucide="rocket" class="inline-block align-middle size-4 rtl:ml-1 ltr:mr-1"></i> Discover now</button> -->
                        <a href="<?php echo e(URL::To('/discover')); ?>" type="button" class="py-2.5 px-6 text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20"><i data-lucide="rocket" class="inline-block align-middle size-4 rtl:ml-1 ltr:mr-1"></i>
                        <span class="align-middle">Discover now</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="relative py-32 bg-slate-900 dark:bg-zink-700" id="features">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="grid grid-cols-1 gap-5 xl:grid-cols-12">
                <div class="order-2 xl:col-span-5 xl:order-1">
                    <!-- <div class="relative z-10 grid grid-cols-3 gap-5 xl:grid-cols-12">
                        <div class="xl:col-span-12">
                            <img src="assets/images/GIO_0556.jpg" alt="" class="shadow-xl rtl:mr-auto ltr:ml-auto rounded-xl">
                        </div>
                        <div class="xl:col-span-6">
                            <img src="assets/images/GIO_1372.jpg" alt="" class="shadow-xl xl:mt-15 rtl:mr-auto ltr:ml-auto rounded-xl">
                        </div>
                        <div class="xl:col-span-6">
                            <img src="assets/images/GIO_0610.jpg" alt="" class="shadow-xl xl:mt-5 rtl:mr-auto ltr:ml-auto rounded-xl">
                        </div>
                    </div> -->
                </div>
                <!-- <div class="relative z-20 order-1 xl:-mt-72 xl:col-span-7 xl:order-last">
                    <img src="assets/images/EJR-Banyuwangi.png" alt="" class="shadow-2xl rounded-xl">
                </div> -->
            </div>
          
        </div>
        <!-- <div class="absolute rotate-45 border border-dashed size-[500px] border-t-slate-700 border-l-slate-700 border-r-slate-700 border-b-slate-700 bottom-48 rounded-full ltr:-left-80 rtl:-right-80 hidden md:block"></div>
        <div class="absolute rotate-45 border border-dashed size-[700px] border-t-slate-700 border-l-slate-700 border-r-slate-700 border-b-slate-700 bottom-24 rounded-full ltr:-left-96 rtl:-right-96 hidden md:block"></div> -->
    </section>
<br>
<br>
    <section class="relative pb-1 bg-slate-50 dark:bg-zink-700/40">
        <div class="container w-full max-w-96">
            <div class="grid grid-cols-1 mt-16 gap-x-5 md:grid-cols-2 xl:grid-cols-4">
            <div class="!shadow-lg text-15 card">
                <a href="<?php echo e(URL::to('/banyuwangi')); ?>">
                    <div class="xl:col-span-3">
                        <div class="transition-all duration-300 ease-linear -mt-36 card hover:-translate-y-2 dark:bg-zink-600">
                            <div class="p-6">
                                <img src="assets/images/lokasi/EJRFKotaBanyuwangi.webp" alt="" class="rounded-md shadow">
                                <div class="mt-6">
                                    <span class="px-2.5 py-0.5 text-xs inline-block font-medium rounded border bg-sky-100 border-sky-200 text-sky-500 dark:bg-sky-500/20 dark:border-sky-500/20">26 Jan 2025</span>
                                    <h6 class="mt-3 mb-2 text-lg truncate"><a href="#!">Banyuwangi</a></h6>
                                    <p class="mb-3 text-slate-500 dark:text-zink-200 text-16">Banyuwangi menawarkan pesona alam memukau, pantai eksotis, gunung megah, dan suasana sejuk, sempurna untuk event olahraga seru!</p>
                                    <a href="<?php echo e(URL::to('/banyuwangi')); ?>" class="text-custom-500 text-16">Read More <i data-lucide="move-right" class="inline-block align-middle size-4 ltr:ml-1 rtl:mr-1 rtl:rotate-180"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </a> 
            </div>
            <div class="!shadow-lg text-15 card">    
                <div class="xl:col-span-3">
                <a href="<?php echo e(URL::to('/kediri')); ?>">
                    <div class="transition-all duration-300 ease-linear xl:-mt-36 card hover:-translate-y-2 dark:bg-zink-600">
                        <div class="p-6">
                            <img src="assets/images/lokasi/EJRFKotaKediri.webp" alt="" class="rounded-md shadow">
                            <div class="mt-6">
                                <span class="px-2.5 py-0.5 text-xs inline-block font-medium rounded border bg-red-100 border-red-200 text-red-500 dark:bg-red-500/20 dark:border-red-500/20">23 Feb 2025</span>
                                <h6 class="mt-3 mb-2 text-lg truncate"><a href="#!">Kediri</a></h6>
                                <p class="mb-3 text-slate-500  dark:text-zink-200 text-16">Kediri, dengan pemandangan alam menakjubkan dan atmosfer semangat, sempurna untuk event olahraga seru dan penuh tantangan!</p>
                                <a href="<?php echo e(URL::to('/kediri')); ?>" class="text-custom-500 text-16">Read More <i data-lucide="move-right" class="inline-block align-middle size-4 ltr:ml-1 rtl:mr-1 rtl:rotate-180"></i></a>
                            </div>
                        </div>
                    </div>
                </a>    
                </div>
            </div>
            <div class="!shadow-lg text-15 card">    
                <div class="xl:col-span-3">
                    <div class="transition-all duration-300 ease-linear -mt-36 card hover:-translate-y-2 dark:bg-zink-600">
                        <div class="p-6">
                            <img src="assets/images/lokasi/FotoKotaEJRF-madiun.webp" alt="" class="rounded-md shadow">
                            <div class="mt-6">
                                <span class="px-2.5 py-0.5 text-xs inline-block font-medium rounded border bg-yellow-100 border-yellow-200 text-yellow-500 dark:bg-sky-500/20 dark:border-sky-500/20">27 Apr 2025</span>
                                <h6 class="mt-3 mb-2 text-lg truncate"><a href="#!">Madiun</a></h6>
                                <p class="mb-3 text-slate-500 dark:text-zink-200 text-16">Madiun, kota indah dengan pemandangan alam menakjubkan, sempurna untuk event olahraga yang berkesan.</p>
                                <a href="<?php echo e(URL::to('/madiun')); ?>" class="text-custom-500 text-16">Read More <i data-lucide="move-right" class="inline-block align-middle size-4 ltr:ml-1 rtl:mr-1 rtl:rotate-180"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  
            <div class="!shadow-lg text-15 card">   
                <div class="xl:col-span-3">
                    <div class="transition-all duration-300 ease-linear xl:-mt-36 card hover:-translate-y-2 dark:bg-zink-600">
                        <div class="p-6">
                            <img src="assets/images/lokasi/EJRFKotaSurabaya.webp" alt="" class="rounded-md shadow">
                            <div class="mt-6">
                                <span class="px-2.5 py-0.5 text-xs inline-block font-medium rounded border bg-green-100 border-green-200 text-green-500 dark:bg-red-500/20 dark:border-red-500/20">22 Jun 2025</span>
                                <h6 class="mt-3 mb-2 text-lg truncate"><a href="#!">Surabaya</a></h6>
                                <p class="mb-3 text-slate-500  dark:text-zink-200 text-16">Surabaya, kota dinamis dengan keindahan alam dan semangat olahraga yang menyatu dalam kebersamaan.</p>
                                <a href="<?php echo e(URL::to('/surabaya')); ?>" class="text-custom-500 text-16">Read More <i data-lucide="move-right" class="inline-block align-middle size-4 ltr:ml-1 rtl:mr-1 rtl:rotate-180"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>    
            </div>
            </div>
           

            
        </div>
    </section>
    <!--end -->

    <!-- <section class="relative py-32" id="about"> -->
        <!-- <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="mx-auto text-center xl:max-w-3xl">
                <h1 class="mb-6 leading-normal capitalize">Why Developers Should Embrace <span class="relative inline-block px-2 mx-2 before:block before:absolute before:-inset-1 before:-skew-y-6 before:bg-sky-50 dark:before:bg-sky-500/20 before:rounded-md before:backdrop-blur-xl"><span class="relative text-sky-500">StarCode</span></span></h1>
                <p class="text-lg text-slate-500 dark:text-zink-200">The purpose of developer communities is to provide the resources for developers to learn anything they want to.</p>
            </div> -->

            <!-- <div class="grid items-center grid-cols-1 gap-6 mt-20 lg:grid-cols-12">
                <div class="lg:col-span-5">
                    <h1 class="mb-3 leading-normal capitalize">Craft a Complete Website Quickly with the Help of Design Blocks</h1>
                    <p class="mb-6 text-lg text-slate-500 dark:text-zink-200">The block design approach basically breaks the design into small parts. These are built independently and then later combine into a customizable page which makes a website more flexible in terms of layout and content.</p>
                    <button type="button" class="py-2.5 px-6 bg-white text-custom-500 btn border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:bg-zink-700 dark:hover:bg-custom-500 dark:ring-custom-400/20 dark:focus:bg-custom-500"><span class="align-middle">Discover Now</span> <i data-lucide="move-right" class="inline-block align-middle size-4 ltr:ml-1 rtl:mr-1 rtl:rotate-180"></i></button>
                </div>
                <div class="text-center lg:col-span-6">
                    <img src="assets/images/widgets-4.jpg" alt="" class="shadow-lg ltr:lg:ml-auto rtl:lg:mr-auto rounded-xl">
                    <img src="assets/images/widgets-5.jpg" alt="" class="relative -mt-24 shadow-lg ltr:ml-auto ltr:mr-24 rtl:mr-auto rtl:ml-24 rounded-xl">
                </div>
            </div> -->

            <!-- <div class="grid items-center grid-cols-1 gap-6 mt-10 lg:grid-cols-12">
                <div class="text-center lg:col-span-6">
                    <img src="assets/images/widgets-6.jpg" alt="" class="shadow-lg ltr:mr-auto rtl:ml-auto rounded-xl">
                    <img src="assets/images/widgets-7.jpg" alt="" class="relative -mt-24 shadow-lg ltr:ml-auto ltr:mr-24 rtl:mr-auto rtl:ml-24 rounded-xl">
                </div>
                <div class="lg:col-span-5">
                    <h1 class="mb-2 leading-normal capitalize">Priode Pendaftaran</h1>
                    <h5 class="mb-2 leading-normal capitalize">Pembukaan pendaftaran</h5>
                    <p class="mb-1 text-lg text-slate-500 dark:text-zink-200">5 September 2024 12.00 WIB</p>
                    <p class="mb-1 text-lg text-slate-500 dark:text-zink-200">Harga pre sale hanya berlaku sampai 8 September 2024 23:59 WIB</p>


                    <h5 class="mb-2 leading-normal capitalize">Penutupan pedaftaran</h5>
                    <p class="mb-1 text-lg text-slate-500 dark:text-zink-200">31 Oktober 2024 23.59 WIB</p>

                </div>
             
                <div class="col-span-12 md:order-9 lg:col-span-6 lg:row-span-2 xl:col-span-4 xl:row-span-2 2xl:row-span-2 2xl:col-span-3 card">
              
                    <div class="card-body">
                        <h6 class="mb-3 text-15 grow">Upcoming Scheduled</h6>
                        <div id="calendar" class="w-auto p-1"></div>
                        <div class="flex flex-col gap-4 mt-3">
                            <div class="flex gap-3">
                                <div class="flex flex-col items-center justify-center border rounded-sm size-16 bg-cyan-100 border-slate-200 dark:border-zink-500 shrink-0"><h6>26</h6>  <span class="text-sm text-slate-500 dark:text-zink-200">Jan</span> 2025</div>
                                <div class="grow">
                                    <h6 class="mb-1">Banyuwangi <small class="inline-block px-2 font-medium border border-transparent rounded text-[11px] py-0.5 bg-slate-100 text-slate-500 dark:bg-slate-500/20 dark:text-zink-200 dark:border-transparent">05:30 AM</small></h6>
                                    <p class="text-slate-500 dark:text-zink-200">Lokasi : TBC</p>
                                </div>
                            </div>
                            <div class="flex gap-3">
                                <div class="flex flex-col items-center justify-center border rounded-sm size-16 bg-pink-200 border-slate-200 dark:border-zink-500 shrink-0">
                                    <h6>23</h6> <span class="text-sm text-slate-500 dark:text-zink-200">Feb</span> 2025
                                </div>
                                <div class="grow">
                                    <h6 class="mb-1">Kediri <small class="inline-block px-2 font-medium border border-transparent rounded text-[11px] py-0.5 bg-slate-100 text-slate-500 dark:bg-slate-500/20 dark:text-zink-200 dark:border-transparent">05:30 AM</small></h6>
                                    <p class="text-slate-500 dark:text-zink-200">Lokasi : TBC</p>
                                </div>
                            </div>
                            <div class="flex gap-3">
                                <div class="flex flex-col items-center justify-center border rounded-sm size-16 border-slate-200 dark:border-zink-500 shrink-0">
                                    <h6>27</h6> <span class="text-sm text-slate-500 dark:text-zink-200">Apr</span>2025
                                </div>
                                <div class="grow">
                                    <h6 class="mb-1">Madiun <small class="inline-block px-2 font-medium border border-transparent rounded text-[11px] py-0.5 bg-slate-100 text-slate-500 dark:bg-slate-500/20 dark:text-zink-200 dark:border-transparent">05:30 PM</small></h6>
                                    <p class="text-slate-500 dark:text-zink-200">Lokasi : TBC</p>
                                </div>
                            </div>
                            <div class="flex gap-3">
                                <div class="flex flex-col items-center justify-center border rounded-sm size-16 bg-yellow-100 border-slate-200 dark:border-zink-500 shrink-0">
                                    <h6>22</h6> <span class="text-sm text-slate-500 dark:text-zink-200">Jun</span>2025
                                </div>
                                <div class="grow">
                                    <h6 class="mb-1">Surabaya <small class="inline-block px-2 font-medium border border-transparent rounded text-[11px] py-0.5 bg-slate-100 text-slate-500 dark:bg-slate-500/20 dark:text-zink-200 dark:border-transparent">05:30 PM</small></h6>
                                    <p class="text-slate-500 dark:text-zink-200">Lokasi : Lapangan Mapolda Jatim</p>
                                </div>
                            </div>
                           
                        </div>
                        
                    </div>
                </div>
             
             
            </div> -->
          

            <!-- <div class="grid items-center grid-cols-1 gap-5 mt-32 lg:grid-cols-12"> -->
                <!-- <div class="lg:col-span-5">
                    <h1 class="mb-3 leading-normal capitalize">Building a User-Friendly Website is Effortless</h1>
                    <p class="mb-4 text-lg text-slate-500 dark:text-zink-200">With a user-friendly interface and easy navigation, the user decreases search time and increases satisfaction, fulfilling his needs in a fast and efficient way.</p>
                    <ul class="flex flex-col gap-3 mb-6 text-lg list-disc list-inside">
                        <li>6+ Ready touse Dashboard</li>
                        <li>Light, Dark & RTL Mode Support</li>
                        <li>Multiple Layouts Support</li>
                    </ul>
                    <button type="button" class="py-2.5 px-6 bg-white text-custom-500 btn border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:bg-zink-700 dark:hover:bg-custom-500 dark:ring-custom-400/20 dark:focus:bg-custom-500"><span class="align-middle">Discover Now</span> <i data-lucide="move-right" class="inline-block align-middle size-4 ltr:ml-1 rtl:mr-1 rtl:rotate-180"></i></button>
                </div> -->
                <!--end col-->
                <!-- <div class="text-center lg:col-span-6">
                    <img src="assets/images/widgets-2.jpg" alt="" class="shadow-lg ltr:ml-auto rtl:mr-auto rounded-xl">
                    <img src="assets/images/widgets.jpg" alt="" class="relative -mt-24 shadow-lg ltr:ml-auto rtl:mr-auto ltr:mr-24 rtl:ml-24 rounded-xl">
                </div> -->
                <!--end col-->
            <!-- </div> -->
           
        <!-- </div> -->
    <!-- </section> -->
    <!--end -->

    <section class="relative pb-32" id="pricing">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="mx-auto text-center xl:max-w-3xl">
               
            </div>

            <!-- disni -->
            <div class="grid items-center grid-cols-1 gap-2 mt-5 lg:grid-cols-12">
                <div class="lg:col-span-5">
                    <h1 class="mb-3 leading-normal capitalize">Run Categories </h1>
                    <p class="mb-4 text-lg text-slate-500 dark:text-zink-200">Lomba ini dibuka untuk warga negara Indonesia dan warga negara asing dengan KITAS dengan usia sesuai usia minimum kategori atau lebih pada hari perlombaan.</p>
                    <ul class="flex flex-col gap-3 mb-6 text-lg list-disc list-inside">
                        <li>Fun Walk (semua umur)</li> 
                        <li>5K (perserta minimum 15 tahun)</li>
                        <li>10K (perserta minimum 15 tahun)</li>
                        <li>HM (perserta minimum 15 tahun)</li>
                    </ul>
                    <h4 class="mb-3 leading-normal capitalize">KIDS DASH </h4>
                    <p class="mb-1 text-lg text-slate-500 dark:text-zink-200">Hanya tersedia di kota surabaya dengan kategori :</p>
                    <p class="mb-1 text-lg text-slate-500 dark:text-zink-200">Kategori A:</p>
                    <ul class="flex flex-col gap-2 mb-6 text-lg list-disc list-inside">
                        <li>Kategori A (Usia 7 - 12 tahun)</li>
                        <li>Rute 400 Meter</li>
                    </ul>
                    <p class="mb-1 text-lg text-slate-500 dark:text-zink-200">Kategori B:</p>
                    <ul class="flex flex-col gap-2 mb-6 text-lg list-disc list-inside">
                        <li>Kategori A (Usia 4 - 6 tahun)</li>
                        <li>Rute 200 Meter</li>
                    </ul>
                </div><!--end col-->
                <!-- <div class="text-center lg:col-span-6">
                    <img src="assets/images/GIO_1421.jpg" alt="" class="shadow-lg ltr:ml-auto rtl:mr-auto rounded-xl">
                    <img src="assets/images/GIO_1033.jpg" alt="" class="relative -mt-24 shadow-lg ltr:ml-auto rtl:mr-auto ltr:mr-24 rtl:ml-24 rounded-xl">
                </div> -->
                <!--end col-->
            </div>
            <!--end grid-->

            <!-- sampai sini -->
            <div class="grid grid-cols-1 mt-16 gap-x-5 md:grid-cols-2 xl:grid-cols-4">
                <div class="!shadow-lg text-15 card">
                    <div class="card-body">
                  
                        <h5 class="mb-2"><i data-lucide="goal" class="text-green-500 inlinesize ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">PRE SALE</span></h5>
                        <p class="mb-4 text-slate-500 dark:text-zink-200"></p>

                       
                        <?php if($bukaBW): ?>
                            <?php if($showButton): ?>
                            <a href="<?php echo e(URL::to('/banyuwangi/#preSale')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                           
                        <?php elseif($bukaKD): ?>
                            <?php if($showButton): ?>
                            <a href="<?php echo e(URL::to('/kediri/#preSale')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                           
                        <?php elseif($bukaMN): ?> 
                            <?php if($showButton): ?>
                            <a href="<?php echo e(URL::to('/madiun/#preSale')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a> 
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?> 
                         
                        <?php elseif($bukaSB): ?>
                            <?php if($showButton): ?>
                            <a href="<?php echo e(URL::to('/surabaya/#preSale')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a> 
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>       
                        <?php else: ?>
                        <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                        <?php endif; ?>
                        <ul class="flex flex-col gap-2 mt-5">
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>Fun Walk</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body">
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>75K</b> (Banyuwangi, Kediri, Madiun)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>85K</b> (Surabaya)</span>
                                    </li>
                                </div>
                            </div>    
                               
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>5K</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body">    
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>200K</b> (Banyuwangi, Kediri, Madiun)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>225K</b> (Surabaya)</span>
                                    </li>
                                </div>
                            </div>    
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>10K</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body"> 
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>250K</b> (Banyuwangi, Kediri, Madiun)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>275K</b> (Surabaya)</span>
                                    </li>
                                </div>
                            </div>    
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>HM</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body"> 
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>300K</b> (Surabaya only)</span>
                                    </li>
                                </div>    
                            </div>                                
                        </ul>
                    </div>
                </div>
                <!--end card-->
                <div class="!shadow-lg text-15 card">
                    <div class="card-body">
                        <h5 class="mb-2"><i data-lucide="graduation-cap" class="text-purple-500 inlinesize ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">REGULER</span></h5>
                        <p class="mb-4 text-slate-500 dark:text-zink-200"></p>

                      
                        <?php if($bukaBW): ?>
                            <?php if($showButton2): ?>
                            <a href="<?php echo e(URL::to('/banyuwangi/#reguler')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                           
                        <?php elseif($bukaKD): ?>
                            <?php if($showButton2): ?>
                            <a href="<?php echo e(URL::to('/kediri/#reguler')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                           
                        <?php elseif($bukaMN): ?> 
                            <?php if($showButton2): ?>
                            <a href="<?php echo e(URL::to('/madiun/#reguler')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>  
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                         
                        <?php elseif($bukaSB): ?>
                            <?php if($showButton2): ?>
                            <a href="<?php echo e(URL::to('/surabaya/#reguler')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a> 
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>      
                        <?php else: ?>
                        <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                        <?php endif; ?>

                        <ul class="flex flex-col gap-2 mt-5">
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>Fun Walk</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body">
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>85K</b> (Banyuwangi, Kediri, Madiun)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>100K</b> (Surabaya)</span>
                                    </li>
                                </div>
                            </div>    
                               
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>5K</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body">    
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>225K</b> (Banyuwangi, Kediri, Madiun)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>250K</b> (Surabaya)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>Khusus Pelajar tetep diharga pre Sale</b></span>
                                    </li>
                                </div>
                            </div>    
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>10K</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body"> 
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>275K</b> (Banyuwangi, Kediri, Madiun)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>300K</b> (Surabaya)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>Khusus Pelajar tetep diharga pre Sale</b></span>
                                    </li>
                                </div>
                            </div>    
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>HM</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body"> 
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>350K</b> (Surabaya only)</span>
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100"></i>
                                        <span><b>Khusus Pelajar tetep diharga pre Sale</b></span>
                                    </li>
                                </div>    
                            </div>                                
                        </ul>
                    </div>
                </div>
                <!--end card-->
                <div class="relative overflow-hidden card shadow-2xl shadow-red-500/50 text-15">
                    <div class="card-body ">
                        <div class="absolute top-0 size-16 ltr:right-0 rtl:left-0">
                            <div class="absolute transform ltr:rotate-45 rtl:-rotate-45 bg-red-500 text-center text-white font-medium py-1 ltr:-right-12 rtl:-left-12 top-6 w-[170px]">
                                Promo
                            </div>
                        </div>
                        <h5 class="mb-2"><i data-lucide="crown" class="inlinesize ltr:mr-1 rtl:ml-1 text-sky-500"></i> <span class="align-middle">BUNDLING</span></h5>
                        <p class="mb-4 text-slate-500 dark:text-zink-200"></p>

                        
                        <?php if($bukaBW): ?>
                            <?php if($showButton3): ?>
                            <a href="<?php echo e(URL::to('/banyuwangi/#bundling')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>

                           
                        <?php elseif($bukaKD): ?>
                            <?php if($showButton3): ?>
                            <a href="<?php echo e(URL::to('/kediri/#bundling')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                           
                        <?php elseif($bukaMN): ?> 
                            <?php if($showButton3): ?>
                            <a href="<?php echo e(URL::to('/madiun/#bundling')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>  
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>
                         
                        <?php elseif($bukaSB): ?>
                            <?php if($showButton3): ?>
                            <a href="<?php echo e(URL::to('/surabaya/#bundling')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>  
                            <?php else: ?>
                            <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                            <?php endif; ?>     
                        <?php else: ?>
                        <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                        <?php endif; ?>
                        
                        <ul class="flex flex-col gap-3 mt-5">
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>Bundling 3 Event (non Surabaya)</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body"> 
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <b>Bundling 5K</b><p class="line-through">675K<p> 630K
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <b>Bundling 10K</b><p class="line-through">825K<p> 780K
                                    </li>
                                    
                                </div>
                            </div>    
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>Bundling 4 Event (include Surabaya)</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body"> 
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <b>Bundling 5K</b><p class="line-through">925K<p> 865K
                                    </li>
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <b>Bundling 10K</b><p class="line-through">1125K<p> 1000K
                                    </li>
                                </div>
                            </div>        
                         
                        </ul>
                    </div>
                </div>
                <!--end card-->
                <div class="!shadow-lg text-15 card">
                    <div class="card-body">
                        <h5 class="mb-2"><i data-lucide="luggage" class="text-orange-500 inlinesize ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">KIDS DASH</span></h5>
                        <p class="mb-4 text-slate-500 dark:text-zink-200"></p>

                        <?php if($bukaSB): ?>
                            <a href="<?php echo e(URL::to('/surabaya/#kidsDash')); ?>" type="button" class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                            <span class="align-middle">Registrasi</span>
                            </a>       
                        <?php else: ?>
                        <button type="button" class="w-full bg-white border-dashed text-slate-500 btn border-slate-500 hover:text-slate-500 hover:bg-slate-50 hover:border-slate-600 focus:text-slate-600 focus:bg-slate-50 focus:border-slate-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">Closed</button>
                        <?php endif; ?>
                        
                        <ul class="flex flex-col gap-3 mt-5">
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>Kategori A</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body">
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>150K</b> 400 Meter</span>
                                    </li>
                                </div>
                            </div>    
                            <li class="flex items-center gap-2">
                                <i data-lucide="check-check" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                <span><b>Kategori B</b></span>
                            </li>
                            <div class="!shadow-lg text-15 card">
                                <div class="card-body">
                                    <li class="flex items-center gap-2">
                                        <i data-lucide="dot" class="inline-block text-green-500 size-4 fill-green-100 dark:fill-green-500/20"></i>
                                        <span><b>125K</b> 200 Meter</span>
                                    </li>
                                </div>
                            </div> 
                          
                        </ul>
                    </div>
                </div>
            
            </div>
            <!--end grid-->
        </div><!--end container-->
    </section>
 

    <section class="relative py-32 bg-yellow-100 dark:bg-custom-800" id="contact">

                                   
                                    <div class="flex justify-center">
                                        <div class="p-0 size-32">
                                            <img src="<?php echo e(URL::to('assets/images/support/polda-jatim.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-32 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
                                        </div>
                                        <div class=" size-32">
                                            <br>
                                            <img src="<?php echo e(URL::to('assets/images/support/korpolairud.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-32 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
                                        </div>
                                        <div class=" size-32">
                                            <br>
                                            <img src="<?php echo e(URL::to('assets/images/support/POLRESTA.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-32 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
                                        </div>
                                    </div>
                                    
                                    
     
     
    </section><br><br>
    <section class="relative pb-10 bg-slate-50 dark:bg-zink-700/40">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto flex justify-center">
            <div class="grid grid-cols-1 gap-6 lg:grid-cols-2 xl:grid-cols-12 gap-x-5">
                <div class="xl:col-span-4">
                    <div class="transition-all duration-300 ease-linear -mt-36  dark:bg-zink-600">
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                    <p class="text-center">Goverment Partner By</p>
                        <div class="p-5 text-center">
                            <img src="assets/images/support/logo_bw.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                    <p class="text-center">Sponsored By</p><br>    
                    <div class="p-0 text-center">
                            <img src="assets/images/logo_sub.PNG" alt="subjersey" >
                        </div>
                    </div>
                </div>
              
                <div class="xl:col-span-2">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                    <p class="text-center">Hosted By</p>
                        <div class="p-10 text-center">
                    
                            <img src="assets/images/ski-logo.PNG" alt="ski" >
                            
                        </div>
                    </div>
                </div>
                
                <div class="xl:col-span-4">
                    <div class="transition-all duration-300 ease-linear xl:-mt-36 card hover:-translate-y-2 dark:bg-zink-600">
                  
                    </div>
                </div>
            </div>
                                  
        </div>
        
    </section>
  
    <!-- <section class="relative pb-10 bg-slate-50"> 
        <div class="mx-auto text-center">
                <p class=" leading-normal capitalize">Sponsored By</p>
            </div>
    </section><br>      

    <section class="relative pb-32 bg-white dark:bg-zink-700/40">

        
       
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="grid grid-cols-1 gap-6 lg:grid-cols-2 xl:grid-cols-12 gap-x-5">
      
                <div class="xl:col-span-2">
                    <div class="transition-all duration-300 ease-linear -mt-36  dark:bg-zink-600">
                    
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                    <p class="text-center"> </p>
                        <div class="size-20 text-center">
                            <img src="assets/images/support/LOGO_SPONSOR_WEB-01.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                    <p class="text-center"></p>
                        <div class="size-20 text-center">
                            <img src="assets/images/support/Logo_Isoplus.jpg" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                
                    <div class="p-0 text-center">
                            <img src="assets/images/support/Sunpride_logo.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                        
                    <div class="p-0 text-center">
                            <img src="assets/images/support/reborn.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                        
                    <div class="p-0 text-center">
                            <img src="assets/images/support/Logo-Atas-1.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                        
                    <div class="p-0 text-center">
                            <img src="assets/images/support/LOGO_SPONSOR_WEB-02.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                        
                    <div class="p-0 text-center">
                            <img src="assets/images/support/LOGO_SPONSOR_WEB-03.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
                <div class="xl:col-span-1">
                    <div class="transition-all duration-300 ease-linear md:-mt-36  dark:bg-zink-600">
                        
                    <div class="p-0 text-center">
                            <img src="assets/images/support/LOGO_SPONSOR_WEB-04.png" alt="subjersey" >
                        </div>
                    </div>
                </div>
            
                
                <div class="xl:col-span-4">
                    <div class="transition-all duration-300 ease-linear xl:-mt-36 card hover:-translate-y-2 dark:bg-zink-600">
                
                    </div>
                </div>
            </div>
        </div>    
    </section> -->

    <section class="relative py-12 bg-white dark:bg-custom-800">
            <div class="mx-auto text-center">
                <p class=" leading-normal capitalize">Sponsored By</p>
            </div>
                               
        <div class="flex justify-center">
            <div class="py-2 size-20">
                <br>
                <img src="<?php echo e(URL::to('assets/images/support/LOGO_SPONSOR_WEB-01.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>
            <div class="py-2 size-20">
                <br>
                <img src="<?php echo e(URL::to('assets/images/support/Logo_Isoplus.jpg')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>
            
            <div class="py-2 size-20">
                <br>
                <img src="<?php echo e(URL::to('assets/images/support/reborn-1.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>

            <div class="py-2 size-20">
            <br>
                <img src="<?php echo e(URL::to('assets/images/support/LOGO_SPONSOR_WEB-04-1.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>
            
          
            <div class="py-2 size-20">
                <br>
                <img src="<?php echo e(URL::to('assets/images/support/LOGO_SPONSOR_WEB-03-1.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>
            <div class="py-2 size-20">
                <br>
                <img src="<?php echo e(URL::to('assets/images/support/LOGO_SPONSOR_WEB-02-1.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>

            <div class="py-2 size-20">
            <br>
                <img src="<?php echo e(URL::to('assets/images/support/Logo-Atas-1-1.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>
            <div class="py-2 size-20">
                <br>
                <img src="<?php echo e(URL::to('assets/images/support/Sunpride_logo.png')); ?>" alt="flex items-center justify-center transition-all duration-200 ease-linear rounded size-30 text-sky-500 bg-sky-100 hover:bg-sky-200 dark:bg-sky-500/20 dark:hover:bg-sky-500/30">
            </div>
           
            
        </div>

    </section><br>


   
            
   
    
   

    <footer class="relative pt-20 pb-12 bg-slate-800 dark:bg-zink-700">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="relative z-10 grid grid-cols-12 gap-5 xl:grid-cols-12">
               
                <div class="col-span-12 md:col-span-6 lg:col-span-4 xl:col-span-2">
                    <h5 class="mb-4 font-medium tracking-wider text-slate-50 dark:text-zink-50">Footer menu</h5>
                    <ul class="flex flex-col gap-3 text-15">
                        <li>
                            <a href="<?php echo e(URL::to('/size')); ?>" data-modal-target="addSizeCart#" class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Size Guide</a>
                        </li>
                        <li>
                            <a href="<?php echo e(URL::to('/terms_and_conditions')); ?>" data-modal-target="TermsOfEntry#" class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Terms and Conditions</a>
                        </li>
                        <li>
                            <a href="<?php echo e(URL::to('/privacy_policy')); ?>" data-modal-target="PrivacyPolicy#" class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Privacy Policy</a>
                        </li>
                        <li>
                            <a href="<?php echo e(URL::to('/refund_policy')); ?>"  class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Refund Policy</a>
                        </li>
                        
                    </ul>
                </div><!--end col-->
                <div class="col-span-12 md:col-span-6 lg:col-span-12 xl:col-span-4">
                    <form action="#!" class="relative mb-6">
                        <input type="email" id="subscribeInput" class="py-3 ltr:pr-40 rtl:pl-40 bg-slate-700/60 dark:bg-zink-600/40 form-input text-slate-200 border-slate-700 dark:border-zink-500 focus:outline-none focus:border-custom-500 dark:focus:border-custom-500 placeholder:text-slate-500 dark:placeholder:text-zink-200 backdrop-blur-md" autocomplete="off" placeholder="eastjavarunfest.com" readonly="" value="eastjavarunfest.com">
                        <button type="submit" class="absolute px-6 py-2 text-base transition-all duration-200 ease-linear border-custom-500 bg-custom-500 ltr:right-1 rtl:left-1 text-custom-50 btn hover:text-custom-50 hover:bg-custom-600 hover:border-custom-600 top-1 bottom-1">Subscribe Now</button>
                    </form>

                    <p class="mb-1 text-slate-500 dark:text-zink-200 text-15">Support Email</p>
                    <h5 class="text-lg !font-normal text-slate-200 dark:text-zink-50">support@eastjavarunningfest.com</h5>

                    <p class="mt-6 mb-1 text-slate-500 dark:text-zink-200 text-15">Contact Us</p>
                    <h5 class="text-lg !font-normal text-slate-200 dark:text-zink-50">081246806392</h5>
                </div>
            </div><!--end grid-->

            <div class="py-5 mt-20 border-y border-slate-700">
                <div class="relative z-10 grid grid-cols-1 gap-5 md:grid-cols-12">
                    <div class="md:col-span-2">
                        <div class="relative dropdown">
                        </div>
                    </div>
                    <div class="md:col-span-3 md:col-start-10">
                        <ul class="flex items-center gap-3 md:justify-end">
                      
                            <li>
                                <a href="#!" class="flex items-center justify-center w-10 h-10 transition-all duration-200 ease-linear border rounded-full text-slate-400 border-slate-700 hover:text-custom-500"><i data-lucide="instagram" class="size-4"></i></a>
                            </li>
                           
                            <li>
                                <a href="#!" class="flex items-center justify-center w-10 h-10 transition-all duration-200 ease-linear border rounded-full text-slate-400 border-slate-700 hover:text-custom-500"><i data-lucide="youtube" class="size-4"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="mt-12 text-center text-slate-400 dark:text-zink-200 text-16">
                <p>
                    <script>document.write(new Date().getFullYear())</script> East Java Run Fest
                </p>
            </div>
        </div>
    </footer>

    <button id="back-to-top" class="fixed flex items-center justify-center w-10 h-10 text-white bg-purple-500 rounded-md bottom-10 right-10">
        <i data-lucide="chevron-up" class="animate animate-icons"></i>
    </button>


    <script src="<?php echo e(URL::to('assets/libs/choices.js/public/assets/scripts/choices.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/%40popperjs/core/umd/popper.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/tippy.js/tippy-bundle.umd.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/simplebar/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/prismjs/prism.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/lucide/umd/lucide.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/starcode.bundle.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/swiper/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/aos/aos.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/dropzone/dropzone-min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/pages/form-file-upload.init.js')); ?>"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script> -->


    <script src="<?php echo e(URL::to('assets/js/pages/landing-product.init.js')); ?>"></script>

    <script>
        // Ambil resolusi layar
        var width = window.innerWidth;
        

        // Tentukan gambar yang akan ditampilkan berdasarkan resolusi
        var imageSrc = width < 700 ? 'assets/images/benner/WEBMOBILE02.webp' : 'assets/images/benner/BANNER-WEB-Baru-02.png';

        // Tampilkan gambar di dalam elemen dengan id "image-container"
        var imgElement = document.createElement('img');
        imgElement.src = imageSrc;
        imgElement.alt = "EJRF";
        imgElement.style.maxWidth = "100%";  // Menjaga agar gambar responsif
        imgElement.style.height = "auto";  // Menjaga aspek rasio gambar
        
        document.getElementById('image-container').appendChild(imgElement);
    </script>

	<script>
        // Ambil resolusi layar
        var width = window.innerWidth;
        

        // Tentukan gambar yang akan ditampilkan berdasarkan resolusi
        var imageSrc = width < 700 ? 'assets/images/benner/WEBMOBILE01.webp' : 'assets/images/benner/BANNER-WEB-Baru-01.png';

        // Tampilkan gambar di dalam elemen dengan id "image-container"
        var imgElement = document.createElement('img');
        imgElement.src = imageSrc;
        imgElement.alt = "EJRF";
        imgElement.style.maxWidth = "100%";  // Menjaga agar gambar responsif
        imgElement.style.height = "auto";  // Menjaga aspek rasio gambar
        
        document.getElementById('image-container2').appendChild(imgElement);
    </script>

    <script>
        // Ambil resolusi layar
        var width = window.innerWidth;
        

        // Tentukan gambar yang akan ditampilkan berdasarkan resolusi
        var imageSrc = width < 700 ? 'assets/images/benner/BANNER-WEB-MOBILE-02.webp' : 'assets/images/benner/BANNER_WEB-02.webp';

        // Tampilkan gambar di dalam elemen dengan id "image-container"
        var imgElement = document.createElement('img');
        imgElement.src = imageSrc;
        imgElement.alt = "EJRF";
        imgElement.style.maxWidth = "100%";  // Menjaga agar gambar responsif
        imgElement.style.height = "auto";  // Menjaga aspek rasio gambar
        
        document.getElementById('image-container3').appendChild(imgElement);
    </script>

<script>
        // Ambil resolusi layar
        var width = window.innerWidth;
        

        // Tentukan gambar yang akan ditampilkan berdasarkan resolusi
        var imageSrc = width < 700 ? 'assets/images/benner/BANNER_WEB_MOBILE-01.webp' : 'assets/images/benner/BANNER_WEB-01.webp';

        // Tampilkan gambar di dalam elemen dengan id "image-container"
        var imgElement = document.createElement('img');
        imgElement.src = imageSrc;
        imgElement.alt = "EJRF";
        imgElement.style.maxWidth = "100%";  // Menjaga agar gambar responsif
        imgElement.style.height = "auto";  // Menjaga aspek rasio gambar
        
        document.getElementById('image-container4').appendChild(imgElement);
    </script>
    




</body>

</html><?php /**PATH C:\xampp\htdocs\runningSystem\resources\views/layoutsutama/master.blade.php ENDPATH**/ ?>