<!DOCTYPE html>
<html lang="en" class="overflow-x-hidden scroll-smooth group" data-mode="light" dir="ltr">

<head>

    <meta charset="utf-8">
    <title>Sub Kreatif Indonesia</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta content="dmin & Dashboard Template" name="description">
    <meta content="subkreatif" name="author">
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(URL::to('assets/images/ski-logo.ico')); ?>">
    <!-- Layout config Js -->
    <script src="<?php echo e(URL::to('assets/js/layout.js')); ?>"></script>
    <!-- Icons CSS -->
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


    <!-- StarCode CSS -->
    

  <link rel="stylesheet" href="<?php echo e(URL::to('assets/css/starcode2.css')); ?>">
</head>

<body class="text-base bg-white text-body font-public dark:text-zink-50 dark:bg-zink-800">

    <nav class="fixed inset-x-0 top-0 z-50 flex items-center justify-center h-20 py-3 [&.is-sticky]:bg-white dark:[&.is-sticky]:bg-zink-700 border-b border-slate-200 dark:border-zink-500 [&.is-sticky]:shadow-lg [&.is-sticky]:shadow-slate-200/25 dark:[&.is-sticky]:shadow-zink-500/30 navbar" id="navbar">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto flex items-center self-center w-full">
            <div class="shrink-0">
                <a href="<?php echo e(URL::to('/')); ?>">
                    <img src="<?php echo e(URL::to('assets/images/ski-logo.png')); ?>" alt="" class="block h-10 dark:hidden">
                    <img src="<?php echo e(URL::to('assets/images/ski-logo.png')); ?>" alt="" class="hidden h-10 dark:block">
                </a>
            </div>
            <div class="mx-auto">
                 <ul id="navbar7" class="absolute inset-x-0 z-20 items-center hidden py-3 bg-white shadow-lg dark:bg-zink-600 dark:md:bg-transparent md:z-0 navbar-menu rounded-b-md md:shadow-none md:flex top-full ltr:ml-auto rtl:mr-auto md:relative md:bg-transparent md:rounded-none md:top-auto md:py-0">
                    <li>
                        <a href="#home" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500 active">Home</a>
                    </li>
                    <li>
                        <a href="<?php echo e(url('/run')); ?>" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Event</a>
                    </li>
                </ul>    
            </div>
            <div class="flex gap-2">
                <div class="ltr:ml-auto rtl:mr-auto md:hidden navbar-toggale-button">
                    <!-- <button type="button" class="flex items-center  justify-center size-[37.5px] p-0 text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20"><i data-lucide="menu"></i></button> -->
                </div>
                
            </div>
        </div>
    </nav>
 
    <?php echo $__env->yieldContent('content'); ?>





 


  

    <footer class="relative pt-20 pb-12 bg-slate-800 dark:bg-zink-700">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
            <div class="relative z-10 grid grid-cols-12 gap-5 xl:grid-cols-12">
                
                
                <!--end col-->
                <div class="col-span-12 md:col-span-6 lg:col-span-4 xl:col-span-4">
                    <h5 class="mb-4 font-medium tracking-wider text-slate-50 dark:text-zink-50">Footer menu</h5>
                    <ul class="flex flex-col gap-3 text-15">
                        <li>
                            <a href="<?php echo e(URL::to('/size')); ?>" data-modal-target="addSizeCart#" class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Tentang Kami</a>
                        </li>
                        <li>
                            <a href="<?php echo e(URL::to('/terms_and_conditions')); ?>" data-modal-target="TermsOfEntry#" class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Terms and Conditions</a>
                        </li>
                        <li>
                            <a href="<?php echo e(URL::to('/privacy_policy')); ?>" data-modal-target="PrivacyPolicy#" class="relative inline-block transition-all duration-200 ease-linear text-slate-400 dark:text-zink-200 hover:text-slate-300 dark:hover:text-zink-50 before:absolute before:border-b before:border-slate-500 dark:before:border-zink-500 before:inset-x-0 before:bottom-0 before:w-0 hover:before:w-full before:transition-all before:duration-300 before:ease-linear">Privacy Policy</a>
                        </li>
                        
                        
                    </ul>
                </div><!--end col-->
                <div class="col-span-12 md:col-span-6 lg:col-span-12 xl:col-span-2">
                    <h5 class="mb-4 font-medium tracking-wider text-slate-50 dark:text-zink-50">Contact Us</h5>
                    <h6 class="text-xs !font-normal text-slate-200 dark:text-zink-50">PT SUB KREATIF INDONESIA</h6>
                    <h6 class="text-xs !font-normal text-slate-200 dark:text-zink-50">Jl. Bratang Gee 3H no 8 Surabaya</h6>
                     <h6 class="text-xs !font-normal text-slate-200 dark:text-zink-50 py-4">admin@subkreatif.com</h6>
                </div>

                <div class="col-span-12 md:col-span-6 lg:col-span-12 xl:col-span-2">
                    <h5 class="mb-4 font-medium tracking-wider text-slate-50 dark:text-zink-50">Registered On</h5>
                    
                </div>
            </div><!--end grid-->

           

            <div class="mt-12 text-center text-slate-400 dark:text-zink-200 text-16">
                <p>
                    <script>document.write(new Date().getFullYear())</script> Sub Kreatif Indonesia
                </p>
            </div>
        </div>
    </footer>

    <button id="back-to-top" class="fixed flex items-center justify-center w-10 h-10 text-white bg-purple-500 rounded-md bottom-10 right-10">
        <i data-lucide="chevron-up" class="animate animate-icons"></i>
    </button>

        <!-- Size Chart-->
        <div id="addSizeCart" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
            <div class="w-screen md:w-[40rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Size Chart</h5>
                    <button data-modal-close="addSizeCart" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        <!-- <div class="grid grid-cols-1 gap-4 xl:grid-cols-12"> -->
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                        
                                <h5 class="mb-2"><span class="align-middle">Man</span></h5>
                                <p class="mb-4 text-slate-500 dark:text-zink-200"></p>
                                <div class="p-10 text-center">
                                    <img src="#" alt="ski" >
                                    
                                </div>
                                
                                
                            </div>
                        </div>

                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                        
                                <h5 class="mb-2"><span class="align-middle">Woman</span></h5>
                                <p class="mb-4 text-slate-500 dark:text-zink-200"></p>
                                <div class="p-10 text-center">
                                    <img src="#" alt="ski" >
                                    
                                </div>
                                
                                
                            </div>
                        </div>
                        
                        <!-- </div> -->
                
                </div>
            </div>
        </div>
        <!--end Size Chart-->

        <!-- Terms Of Entry-->
        <div id="TermsOfEntry" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
            <div class="w-screen md:w-[44rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Terms of Entry</h5>
                    <button data-modal-close="TermsOfEntry" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        <!-- <div class="grid grid-cols-1 gap-4 xl:grid-cols-12"> -->
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                        
                            
                                <p class="mb-4 text-slate-500 dark:text-zink-200">
                                Dengan mendaftarkan diri di EJRF Saya menyetujui persyaratan dan ketentuan berikut:
                                </p>

                                <p class="mb-4 text-slate-500 dark:text-zink-200">1. Saya menyatakan bahwa saya berusia 15 tahun atau lebih.</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">2. Peserta EJRF wajib berusia 15 tahun atau lebih. Peserta 10K dan 5K wajib berusia 15 tahun atau lebih. Peserta Kids Dash Kategori A wajib berusia 7 - 12 tahun. Peserta Kids Dash Kategori A wajib berusia 4 - 6 tahun. Fun Walk semua usia. Penyelenggara berhak melakukan verifikasi atas usia peserta sebelum, pada saat dan sesudah lomba.</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">3. Penyelenggara berhak menutup pendaftaran jika seluruh kuota pesertanya telah terisi penuh.</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">4. Pendaftaran akan diproses setelah pembayaran diterima lunas.</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">5. Biaya pendaftaran tidak dapat dikembalikan dan tidak dapat dipindahtangankan dan memberi hak partisipasi untuk orang yang nama dan nomor identitas tercantum dalam formulir pendaftaran. Penyelenggara berhak menolak masuk peserta yang memberikan informasi palsu, tidak melakukan pembayaran sesuai persyaratan, atau gagal memenuhi persyaratan sebagaimana tercantum dalam Syarat dan Ketentuan dan Peraturan Lomba.</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">6. Jika acara dibatalkan karena keadaan di luar kendali Penyelenggara (tidak terbatas pada hujan deras, badai, bencana alam lainnya atau unjuk rasa), tidak ada pengembalian biaya pendaftaran dan Penyelenggara tidak akan bertanggung jawab.</p>
                               
                                
                                
                            </div>
                        </div>

                     
                        
                        <!-- </div> -->
                
                </div>
            </div>
        </div>
        <!--end Terms Of Entry-->

        <!-- Privacy Policy-->
        <div id="PrivacyPolicy" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
            <div class="w-screen md:w-[44rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Privacy Policy</h5>
                    <button data-modal-close="PrivacyPolicy" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        <!-- <div class="grid grid-cols-1 gap-4 xl:grid-cols-12"> -->
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                        
                            
                            <h5 class="text-16">KEBIJAKAN PRIVASI</h5>

                                <p class="mb-4 text-slate-500 text-justify dark:text-zink-200">
Data Privasi adalah hal yang sangat penting dikarenakan menyangkut kepercayaan dan privasi konsumen yaitu anda. Oleh karena itu kami memahami dan menghormati privasi anda dengan hanya menggunakan nama dan informasi yang berkaitan dengan Anda sebagaimana tercantum dalam Kebijakan Privasi kami.
Kebijakan Privasi ini menjelaskan bagaimana www.subjersey.com mengumpulkan, mengatur dan melindungi informasi Anda ketika Anda mengunjungi dan/atau menggunakan situs. Dengan mengakses situs ini kami menganggap Anda menerima syarat dan ketentuan Kebijakan Privasi.</p>
                                <h5 class="text-16">PENGUMPULAN INFORMASI PRIBADI</h5>
                                <p class="mb-4 text-slate-500 text-justify dark:text-zink-200">
                                Bila Anda membuat akun dalam Situs www.subjersey.com, informasi pribadi yang kami kumpulkan termasuk tapi tidak terbatas pada nama, alamat pengiriman, alamat email, nomor telepon, nomor ponsel, tanggal lahir, jenis kelamin dan negara asal.
                                </p>
                                <h5 class="text-16">PENGGUNAAN INFORMASI PRIBADI</h5>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">Kami menggunakan informasi pribadi dari anda untuk dan tidak terbatas pada hal – hal sebagai berikut :</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">6. Jika acara dibatalkan karena keadaan di luar kendali Penyelenggara (tidak terbatas pada hujan deras, badai, bencana alam lainnya atau unjuk rasa), tidak ada pengembalian biaya pendaftaran dan Penyelenggara tidak akan bertanggung jawab.</p>
                               
                                
                                
                            </div>
                        </div>

                     
                        
                        <!-- </div> -->
                
                </div>
            </div>
        </div>
        <!--end Privacy Policy-->


        <!-- Refound Policy-->
        <div id="RefoundPolicy" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
            <div class="w-screen md:w-[44rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Refound Policy</h5>
                    <button data-modal-close="RefoundPolicy" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        <!-- <div class="grid grid-cols-1 gap-4 xl:grid-cols-12"> -->
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                        
                            
                            <h5 class="text-16">KEBIJAKAN PRIVASI</h5>

                                <p class="mb-4 text-slate-500 text-justify dark:text-zink-200">
Data Privasi adalah hal yang sangat penting dikarenakan menyangkut kepercayaan dan privasi konsumen yaitu anda. Oleh karena itu kami memahami dan menghormati privasi anda dengan hanya menggunakan nama dan informasi yang berkaitan dengan Anda sebagaimana tercantum dalam Kebijakan Privasi kami.
Kebijakan Privasi ini menjelaskan bagaimana www.subjersey.com mengumpulkan, mengatur dan melindungi informasi Anda ketika Anda mengunjungi dan/atau menggunakan situs. Dengan mengakses situs ini kami menganggap Anda menerima syarat dan ketentuan Kebijakan Privasi.</p>
                                <h5 class="text-16">PENGUMPULAN INFORMASI PRIBADI</h5>
                                <p class="mb-4 text-slate-500 text-justify dark:text-zink-200">
                                Bila Anda membuat akun dalam Situs www.subjersey.com, informasi pribadi yang kami kumpulkan termasuk tapi tidak terbatas pada nama, alamat pengiriman, alamat email, nomor telepon, nomor ponsel, tanggal lahir, jenis kelamin dan negara asal.
                                </p>
                                <h5 class="text-16">PENGGUNAAN INFORMASI PRIBADI</h5>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">Kami menggunakan informasi pribadi dari anda untuk dan tidak terbatas pada hal – hal sebagai berikut :</p>
                                <p class="mb-4 text-slate-500 dark:text-zink-200">6. Jika acara dibatalkan karena keadaan di luar kendali Penyelenggara (tidak terbatas pada hujan deras, badai, bencana alam lainnya atau unjuk rasa), tidak ada pengembalian biaya pendaftaran dan Penyelenggara tidak akan bertanggung jawab.</p>
                               
                                
                                
                            </div>
                        </div>

                     
                        
                        <!-- </div> -->
                
                </div>
            </div>
        </div>
        <!--end Refound Policy-->


 <?php echo $__env->yieldContent('script'); ?>

    <script src="<?php echo e(URL::to('assets/libs/choices.js/public/assets/scripts/choices.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/%40popperjs/core/umd/popper.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/tippy.js/tippy-bundle.umd.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/simplebar/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/prismjs/prism.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/libs/lucide/umd/lucide.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/StarCode.bundle.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/pages/landing-onepage.init.js')); ?>"></script>

    <script src="<?php echo e(URL::to('assets/js/datatables/jquery-3.7.0.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/data-tables.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/data-tables.tailwindcss.min.js')); ?>"></script>
    
      <!--buttons dataTables-->
    <script src="<?php echo e(URL::to('assets/js/datatables/datatables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/datatables.init.js')); ?>"></script>

    <script src="<?php echo e(URL::to('assets/js/datatables/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('assets/js/datatables/datatables.init.js')); ?>"></script>
    


    <script>
        document.addEventListener("contextmenu", function(e){
            e.preventDefault();
        }, false);
    </script>


  
</body>

</html><?php /**PATH C:\xampp\htdocs\runningSystem\resources\views/layoutsutama/master3.blade.php ENDPATH**/ ?>