<?php


use App\Models\Tiket;
use App\Mail\SendEmail;
use App\Models\Country;
use App\Models\Peserta;
use App\Models\Preskon;
use App\Models\Provinsi;
use App\Models\Lokasi_run;
use App\Models\KategoryEvent;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\QRCodeController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\RegistrasiController;


/** for side bar menu active */
function set_active($route) {
    if (is_array($route )){
        return in_array(Request::path(), $route) ? 'active' : '';
    }
    return Request::path() == $route ? 'active' : '';
}
/** for side bar menu show */
function set_show($route) {
    if (is_array($route )){
        return in_array(Request::path(), $route) ? 'show' : '';
    }
    return Request::path() == $route ? 'show' : '';
}

Route::get('/admin', function () {
    return view('auth.login');
});
Route::get('/', function () {
    $tiket_pre = Tiket::where('id_tiket','sRkD9')
                ->get();
                // Ambil tanggal saat ini
                $currentDate = date('Y-m-d');        
    $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

    $reguler = Tiket::where('id_tiket','RMbaT')
                ->get();
                // Ambil tanggal saat ini
                $currentDate = date('Y-m-d');        
    $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


    $bundling = Tiket::where('id_tiket','lDHcl')
                        ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    


    $kids_dash = Tiket::where('id_tiket','M3ys7')
                        ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton4 = $currentDate >= $kids_dash[0]->tgl_tiket_mulai && $currentDate <= $kids_dash[0]->tgl_tiket_selesai;   
    
    $currentDateRun = date('Y-m-d');      
    $lokRunBW = Lokasi_run::where('kode_lokasi','BW')->get();
    $bukaBW = $currentDateRun >= $lokRunBW[0]->tiket_buka && $currentDateRun <= $lokRunBW[0]->tiket_tutup;

    $currentDateRunKD = date('Y-m-d');      
    $lokRunKD = Lokasi_run::where('kode_lokasi','KD')->get();
    $bukaKD = $currentDateRunKD >= $lokRunKD[0]->tiket_buka && $currentDateRunKD <= $lokRunKD[0]->tiket_tutup;

    $currentDateRunMN = date('Y-m-d');      
    $lokRunMN = Lokasi_run::where('kode_lokasi','MN')->get();
    $bukaMN = $currentDateRunMN >= $lokRunMN[0]->tiket_buka && $currentDateRunMN <= $lokRunMN[0]->tiket_tutup;

    $currentDateRunSB = date('Y-m-d');      
    $lokRunSB = Lokasi_run::where('kode_lokasi','MN')->get();
    $bukaSB = $currentDateRunSB >= $lokRunSB[0]->tiket_buka && $currentDateRunSB <= $lokRunSB[0]->tiket_tutup;

    
    return view('home.home',compact('showButton','showButton2','showButton3','showButton4','tiket_pre','kids_dash','reguler','bundling','bukaBW','bukaKD','bukaMN','bukaSB'));
});

Route::get('/peserta', function () {
    $peserta = DB::table('peserta')
                ->join('kat_event', 'peserta.package', '=', 'kat_event.id_kat_event')   
                ->join('kabupatens','peserta.kabupaten','=','kabupatens.id')
                ->get();
    return view('home.peserta',compact('peserta'));
});

Route::get('/story', function () {
    $pres = Preskon::all();
    return view('home.story',compact('pres'));
});


Route::get('/discover', function () {
    return view('home.discover');
});
Route::get('/lokasiEvent', function () {
    return view('home.lokasi');
});
Route::get('/banyuwangi', function () {
    $kode = 'ELyx4';
    $kode2 = 'KBch0';
    $kode3 = 'q72VN';
    $kode4 = 'SNS3O';
    $kode5 = 'QuovV';
    $kode6 = 'ptBPk';
    $kode7 = 'MLqi4';
    $tik = 'sRkD9';
    $reg = 'RMbaT';
    $bundl ='lDHcl';
    $kds ='M3ys7';
    $kota = 'BW';


    $tiket_pre = Tiket::where('id_tiket','sRkD9')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

    $reguler = Tiket::where('id_tiket','RMbaT')
        ->get();
        // Ambil tanggal saat ini
        $currentDate = date('Y-m-d');        
    $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


    $bundling = Tiket::where('id_tiket','lDHcl')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    

    $kidsDash = Tiket::where('id_tiket',$kds)->get();
    $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai && $currentDate <= $kidsDash[0]->tgl_tiket_selesai;
    
    $currentDateRun = date('Y-m-d');      
    $lokRun = Lokasi_run::where('kode_lokasi','LIKE','%'.$kota.'%')->get();
    $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;
    $cek_pes_fw = Peserta::where('package','ELyx4')->where('lokasi_run','BW')->where('pembayaran','Paid')->count();
    $cek = ($cek_pes_fw);
    $quo = KategoryEvent::where('id_kat_event','ELyx4')->get();
    $quot =$quo[0]->quota;


    return view('home.banyuwangi',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','showButton','showButton2','showButton3','showButton4','kota','buka','cek','quot'));
});

Route::get('/kediri', function () {
    $kode = 'ELyx4';
    $kode2 = 'KBch0';
    $kode3 = 'q72VN';
    $kode4 = 'SNS3O';
    $kode5 = 'QuovV';
    $kode6 = 'ptBPk';
    $kode7 = 'MLqi4';
    $tik = 'sRkD9';
    $reg = 'RMbaT';
    $bundl ='lDHcl';
    $kds ='M3ys7';
    $kota ='KD';

    $tiket_pre = Tiket::where('id_tiket','sRkD9')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

    $reguler = Tiket::where('id_tiket','RMbaT')
        ->get();
        // Ambil tanggal saat ini
        $currentDate = date('Y-m-d');        
    $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


    $bundling = Tiket::where('id_tiket','lDHcl')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    

    $kidsDash = Tiket::where('id_tiket',$kds)->get();
    $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai && $currentDate <= $kidsDash[0]->tgl_tiket_selesai; 
    
    $currentDateRun = date('Y-m-d');      
    $lokRun = Lokasi_run::where('kode_lokasi',$kota)->get();
    $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;


    return view('home.kediri',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','showButton','showButton2','showButton3','showButton4','kota','buka'));
});

Route::get('/madiun', function () {
    $kode = 'ELyx4';
    $kode2 = 'KBch0';
    $kode3 = 'q72VN';
    $kode4 = 'SNS3O';
    $kode5 = 'QuovV';
    $kode6 = 'ptBPk';
    $kode7 = 'MLqi4';
    $tik = 'sRkD9';
    $reg = 'RMbaT';
    $bundl ='lDHcl';
    $kds ='M3ys7';
    $kota ='KD';

    $tiket_pre = Tiket::where('id_tiket','sRkD9')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

    $reguler = Tiket::where('id_tiket','RMbaT')
        ->get();
        // Ambil tanggal saat ini
        $currentDate = date('Y-m-d');        
    $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


    $bundling = Tiket::where('id_tiket','lDHcl')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    

    $kidsDash = Tiket::where('id_tiket',$kds)->get();
    $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai && $currentDate <= $kidsDash[0]->tgl_tiket_selesai; 
    
    $currentDateRun = date('Y-m-d');      
    $lokRun = Lokasi_run::where('kode_lokasi',$kota)->get();
    $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;


    return view('home.madiun',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','showButton','showButton2','showButton3','showButton4','kota','buka'));
});

Route::get('/surabaya', function () {
    $kode = 'ELyx4';
    $kode2 = 'KBch0';
    $kode3 = 'q72VN';
    $kode4 = 'SNS3O';
    $kode5 = 'QuovV';
    $kode6 = 'ptBPk';
    $kode7 = 'MLqi4';
    $tik = 'sRkD9';
    $reg = 'RMbaT';
    $bundl ='lDHcl';
    $kds ='M3ys7';
    $kota ='KD';

    $tiket_pre = Tiket::where('id_tiket','sRkD9')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

    $reguler = Tiket::where('id_tiket','RMbaT')
        ->get();
        // Ambil tanggal saat ini
        $currentDate = date('Y-m-d');        
    $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


    $bundling = Tiket::where('id_tiket','lDHcl')
                ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    

    $kidsDash = Tiket::where('id_tiket',$kds)->get();
    $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai && $currentDate <= $kidsDash[0]->tgl_tiket_selesai;   
    
    $currentDateRun = date('Y-m-d');      
    $lokRun = Lokasi_run::where('kode_lokasi',$kota)->get();
    $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;


    return view('home.surabaya',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','showButton','showButton2','showButton3','showButton4','kota','buka'));
});

Route::get('/refund_policy', function () {
    return view('home.refund_policy');
});

Route::get('/terms_and_conditions', function () {
    return view('home.terms_and_conditions');
});

Route::get('/privacy_policy', function () {
    return view('home.privacy_policy');
});

Route::get('/size', function () {
    return view('home.size');
});
Route::get('/email', function () {
    return view('emails.send_email');
});

Route::get('/registrasi', [RegistrasiController::class, 'registrasi']);
Route::get('/registrasiPree/{kode}', [RegistrasiController::class, 'registrasiPree'])->name('registrasiPree');
Route::get('/registrasiPresale/{kode}/{kd}/{kota}', [RegistrasiController::class, 'registrasiPresale'])->name('registrasiPresale');
Route::get('/kabupatens/{provinsiId}', [RegistrasiController::class, 'getKabupatens']);
Route::get('/get-items/{kode}', [RegistrasiController::class, 'getItems']);
Route::get('/get-items2/{kode}/{kd}', [RegistrasiController::class, 'getItems2']);
// Route::get('/get-lokasi', [RegistrasiController::class, 'getLokasi']);
Route::post('/registrasi/run', [RegistrasiController::class, 'saveRegistrasi'])->name('registrasirun');
Route::get('/registrasiPreview/{kode}', [RegistrasiController::class, 'registrasiPreview'])->name('registrasiPreview');
Route::get('/checkout/success/{transaction}',[RegistrasiController::class, 'success'])->name('checkout-success');
Route::post('/notification', [RegistrasiController::class, 'notificationHandler'])->name('notification');

Route::get('/certificates/verify/{id}', [RegistrasiController::class, 'verify'])->name('certificates.verify');


Route::get('qr-code', [QRCodeController::class, 'index']);
Route::get('generate-pdf/{kode}', [PDFController::class, 'generatePDF']);

Route::get('/mail/send/{koders}', [RegistrasiController::class, 'kirimEmail']);

Route::post('/midtrans-notification', [PaymentController::class, 'handleNotification']);

Route::group(['middleware'=>'auth'],function()
{
    Route::get('home',function()
    {
        return view('dashboard.home');
    });

});


Auth::routes();

Route::group(['namespace' => 'App\Http\Controllers\Auth'],function()
{
    // -----------------------------login----------------------------------------//
    Route::controller(LoginController::class)->group(function () {
        Route::get('/login', 'login')->name('login');
        Route::post('/login', 'authenticate');
        Route::get('/logout', 'logout')->name('logout');
        Route::get('logout/page', 'logoutPage')->name('logout/page');
    });





    // ------------------------------ register ----------------------------------//
    Route::controller(RegisterController::class)->group(function () {
        Route::get('/register', 'register')->name('register');
        Route::get('/registerAdmin', 'registerAdmin')->name('registerAdmin');
        Route::post('/register','storeUser')->name('register');    
    });

    // ----------------------------- forget password ----------------------------//
    Route::controller(ForgotPasswordController::class)->group(function () {
        Route::get('forget-password', 'getEmail')->name('forget-password');
        Route::post('forget-password', 'postEmail')->name('forget-password');    
    });

    // ----------------------------- reset password -----------------------------//
    Route::controller(ResetPasswordController::class)->group(function () {
        Route::get('reset-password/{token}', 'getPassword');
        Route::post('reset-password', 'updatePassword');    
    });
});

Route::group(['namespace' => 'App\Http\Controllers'],function()
{
    // -------------------------- main dashboard ----------------------//
    Route::controller(HomeController::class)->group(function () {
        Route::get('/home', 'index')->middleware('auth')->name('home');
    });

     // -------------------------- peserta ----------------------//
     Route::middleware('auth')->prefix('peserta/')->group(function () {
        Route::controller(PesertaController::class)->group(function () {
            Route::get('list', 'pesertaList')->name('peserta/list/banyuwangi');
            Route::get('listMadiun', 'pesertaMadiun')->name('peserta/list/madiun');
            Route::get('listKediri', 'pesertaKediri')->name('peserta/list/kediri');
            Route::get('listSurabaya', 'pesertaSurabaya')->name('peserta/list/surabaya');
            Route::get('export/{kode_id}', 'pesertaExport')->name('peserta/export');
            Route::get('kirimEmail/{kode_id}', 'kirimEmail')->name('peserta/kirimEmail');
        });
    });


      // -------------------------- Tiket ----------------------//
      Route::middleware('auth')->prefix('tiket/')->group(function () {
        Route::controller(TiketController::class)->group(function () {
            Route::get('list', 'tiketList')->name('tiket/list');
            Route::post('save', 'saveRecordtiket')->name('tiketSave'); // add new tiket record 
            Route::post('update', 'tiketUpdateRecord')->name('tiketUpdate'); //update tiket record
            Route::post('deletess', 'tiketDeleteRecord')->name('tiketDel'); // delete tiket record

            Route::get('listHarga', 'hargaTiketlist')->name('harga/tiket/list');
            Route::post('saveHarga', 'saveRecordharga')->name('hargaTiketsave'); // add new harga tiket record 
            Route::post('updateHarga', 'tiketHargaUpdateRecord')->name('tiketHargaupdate'); //update tiket record

            Route::get('kategorirunlist', 'kategoryRunList')->name('kategori_run/list');
            Route::post('kategorirunSave', 'saveRecordkategorirun')->name('kategorirunSave'); // add new Category Event record 
            Route::post('updateKatrun', 'kategorirunUpdateRecord')->name('kategorirunUpdate'); //update category Event record
            Route::post('delete', 'kategorirunDeleteRecord')->name('kategorirunDelete'); // delete category Event record
        
            Route::get('listLokasi', 'lokasiList')->name('lokasi/list'); 
            Route::post('saveLokasi', 'saveRecordlokasi')->name('lokasiSave'); // add new location event record 
            Route::post('updateLokasi', 'lokasiUpdateRecord')->name('lokasiUpdate'); //update tiket record
            Route::post('deleteLokasi', 'lokasiDeleteRecord')->name('lokasiDelete'); // delete category Event record

            
            Route::get('kategori/peserta', 'kategoriPeserta')->name('kategori/peserta'); 
        });
    });
    

    // -------------------------- pages ----------------------//
    Route::controller(AccountController::class)->group(function () {
        Route::get('page/account/list', 'accountList')->middleware('auth')->name('accountList');
        Route::post('page/account/save', 'accountSaveRecord')->middleware('auth')->name('accountsave');
        Route::post('page/account/edit', 'accountEditRecord')->middleware('auth')->name('accountEdit');
        Route::get('page/account/{user_id}', 'profileDetail')->middleware('auth')->name('profileDetail');
        
    });



           // -------------------------- Pengaturan umum ----------------------//
           Route::middleware('auth')->prefix('general/')->group(function () {
            Route::controller(GeneralController::class)->group(function () {
                Route::get('list', 'generalList')->name('generalList'); // setting general
                Route::get('editGeneral/{kode}', 'editGeneral')->name('editGeneral'); // edit setting general
                Route::post('save', 'saveRecordgeneral')->name('generalSave'); // add new produk record 
                Route::post('editGeneralakun/{kode}', 'editRecordgeneralAkun')->name('generalAkunedit'); // add new produk record    
                Route::post('editGeneralpenjualan', 'editRecordgeneralPenjualan')->name('generalPenjualanedit'); // edit general penjualan record    
            });
        });



    
});


