<?php


use App\Models\Tiket;
use App\Mail\SendEmail;
use App\Models\Country;
use App\Models\Peserta;
use App\Models\Preskon;
use App\Models\Provinsi;
use App\Models\Lokasi_run;
use App\Livewire\GudangList;
use App\Models\KategoryEvent;
// use App\Http\Livewire\PesertaList;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\QRCodeController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\RegistrasiController;


/** for side bar menu active */
function set_active($route) {
    if (is_array($route )){
        return in_array(Request::path(), $route) ? 'active' : '';
    }
    return Request::path() == $route ? 'active' : '';
}
/** for side bar menu show */
function set_show($route) {
    if (is_array($route )){
        return in_array(Request::path(), $route) ? 'show' : '';
    }
    return Request::path() == $route ? 'show' : '';
}

Route::get('/admin', function () {
    return view('auth.login');
});
Route::get('/', function () {
    $tiket_pre = Tiket::where('id_tiket','sRkD9')
                ->get();
                // Ambil tanggal saat ini
                $currentDate = date('Y-m-d');        
    $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

    $reguler = Tiket::where('id_tiket','RMbaT')
                ->get();
                // Ambil tanggal saat ini
                $currentDate = date('Y-m-d');        
    $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


    $bundling = Tiket::where('id_tiket','lDHcl')
                        ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    


    $kids_dash = Tiket::where('id_tiket','M3ys7')
                        ->get();
    // Ambil tanggal saat ini
    $currentDate = date('Y-m-d');        
    $showButton4 = $currentDate >= $kids_dash[0]->tgl_tiket_mulai && $currentDate <= $kids_dash[0]->tgl_tiket_selesai;   
    
    $currentDateRun = date('Y-m-d');      
    $lokRunBW = Lokasi_run::where('kode_lokasi','BW')->get();
    $bukaBW = $currentDateRun >= $lokRunBW[0]->tiket_buka && $currentDateRun <= $lokRunBW[0]->tiket_tutup;

    $currentDateRunKD = date('Y-m-d');      
    $lokRunKD = Lokasi_run::where('kode_lokasi','KD')->get();
    $bukaKD = $currentDateRunKD >= $lokRunKD[0]->tiket_buka && $currentDateRunKD <= $lokRunKD[0]->tiket_tutup;

    $currentDateRunMN = date('Y-m-d');      
    $lokRunMN = Lokasi_run::where('kode_lokasi','MN')->get();
    $bukaMN = $currentDateRunMN >= $lokRunMN[0]->tiket_buka && $currentDateRunMN <= $lokRunMN[0]->tiket_tutup;

    $currentDateRunSB = date('Y-m-d');      
    $lokRunSB = Lokasi_run::where('kode_lokasi','MN')->get();
    $bukaSB = $currentDateRunSB >= $lokRunSB[0]->tiket_buka && $currentDateRunSB <= $lokRunSB[0]->tiket_tutup;

    
    return view('home.home',compact('showButton','showButton2','showButton3','showButton4','tiket_pre','kids_dash','reguler','bundling','bukaBW','bukaKD','bukaMN','bukaSB'));
});

// Route::get('/peserta', function () {
//     $peserta = DB::table('peserta')
//                 ->join('kat_event', 'peserta.package', '=', 'kat_event.id_kat_event')   
//                 ->join('kabupatens','peserta.kabupaten','=','kabupatens.id')
//                 ->join('kategori_peserta','peserta.category','=','kategori_peserta.kategori_idp')
//                 ->get();
//     return view('home.peserta',compact('peserta'));
// });

// Route::get('/hasil_bwi', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','KBch0')
//                 ->where('jenis_kelamin','pria')
//                 ->where('ctr_run',1)
//                ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/5K_open_women', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','KBch0')
//                 ->where('jenis_kelamin','Wanita')
//                 ->where('ctr_run',1)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/5K_pelajar_women', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','KBch0')
//                 ->where('jenis_kelamin','Wanita')
//                 ->where('ctr_run',2)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/5K_pelajar_man', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','KBch0')
//                 ->where('jenis_kelamin','pria')
//                 ->where('ctr_run',2)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/10K_pelajar_man', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','q72VN')
//                 ->where('jenis_kelamin','pria')
//                 ->where('ctr_run',2)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/10K_pelajar_woman', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','q72VN')
//                 ->where('jenis_kelamin','Wanita')
//                 ->where('ctr_run',2)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/10K_master_man', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','q72VN')
//                 ->where('jenis_kelamin','pria')
//                 ->where('ctr_run',5)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/10K_open_man', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','q72VN')
//                 ->where('jenis_kelamin','pria')
//                 ->where('ctr_run',1)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

// Route::get('/10K_open_woman', function () {
//     $hasil = DB::table('race_result')
//                 ->where('category','q72VN')
//                 ->where('jenis_kelamin','Wanita')
//                 ->where('ctr_run',1)
//                 ->orderBy('rank', 'asc')
//                 ->get();
//     return view('home.hasil',compact('hasil'));
// });

Route::get('/lokasi', function () {

    // Data lokasi Madiun
    $lokasi = Lokasi_run::where('active_lokasi_run', 1)
        ->where('kode_lokasi', 'MN')
        ->get();

    $currentDate = date('Y-m-d');        
    $bwi = false;
    if (isset($lokasi[0])) {
        $bwi = $currentDate >= $lokasi[0]->tiket_buka && $currentDate <= $lokasi[0]->tiket_tutup;    
    } 

   // Data lokasi Surabaya
   $lokasisby = Lokasi_run::where('active_lokasi_run', 1)
        ->where('kode_lokasi', 'SB')
        ->get();

    $sby = false;
    if (isset($lokasisby[0])) {
        $sby = $currentDate >= $lokasisby[0]->tiket_buka && $currentDate <= $lokasisby[0]->tiket_tutup;    
    }  
    return view('home.lokasi_run',compact('lokasi','bwi','sby','lokasisby'));
});

Route::get('/story', function () {
    $pres = Preskon::all();
    return view('home.story',compact('pres'));
});


Route::get('/discover', function () {
    return view('home.discover');
});
Route::get('/lokasiEvent', function () {
    return view('home.lokasi');
});
// Route::get('/banyuwangi', function () {
//     $kode = 'ELyx4';
//     $kode2 = 'KBch0';
//     $kode3 = 'q72VN';
//     $kode4 = 'SNS3O';
//     $kode5 = 'QuovV';
//     $kode6 = 'ptBPk';
//     $kode7 = 'MLqi4';
//     $tik = 'sRkD9';
//     $reg = 'RMbaT';
//     $bundl ='lDHcl';
//     $kds ='M3ys7';
//     $kota = 'BW';


//     $tiket_pre = Tiket::where('id_tiket','sRkD9')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai;    

//     $reguler = Tiket::where('id_tiket','RMbaT')
//         ->get();
//         // Ambil tanggal saat ini
//         $currentDate = date('Y-m-d');        
//     $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai && $currentDate <= $reguler[0]->tgl_tiket_selesai;    


//     $bundling = Tiket::where('id_tiket','lDHcl')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai && $currentDate <= $bundling[0]->tgl_tiket_selesai;    

//     $kidsDash = Tiket::where('id_tiket',$kds)->get();
//     $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai && $currentDate <= $kidsDash[0]->tgl_tiket_selesai;
    
//     $currentDateRun = date('Y-m-d');      
//     $lokRun = Lokasi_run::where('kode_lokasi','LIKE','%'.$kota.'%')->get();
//     $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;
//     $cek_pes_fw = Peserta::where('package','ELyx4')->where('lokasi_run','BW')->where('pembayaran','Paid')->count();
//     $cek = ($cek_pes_fw);
//     $quo = KategoryEvent::where('id_kat_event','ELyx4')->get();
//     $quot =$quo[0]->quota;

//     return view('home.banyuwangi',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','showButton','showButton2','showButton3','showButton4','kota','buka','cek','quot'));
// });

// Route::get('/kediri', function () {
//     $kode = 'ELyx4';
//     $kode2 = 'KBch0';
//     $kode3 = 'q72VN';
//     $kode4 = 'SNS3O';
//     $kode5 = 'QuovV';
//     $kode6 = 'ptBPk';
//     $kode7 = 'MLqi4';
//     $tik = 'sRkD9';
//     $reg = 'RMbaT';
//     $bundl ='lDHcl';
//     $kds ='M3ys7';
//     $kota ='KD';

//     $tiket_pre = Tiket::where('id_tiket','sRkD9')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai_kediri && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai_kediri;    

//     $reguler = Tiket::where('id_tiket','RMbaT')
//         ->get();
//         // Ambil tanggal saat ini
//         $currentDate = date('Y-m-d');        
//     $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai_kediri && $currentDate <= $reguler[0]->tgl_tiket_selesai_kediri;    


//     $bundling = Tiket::where('id_tiket','lDHcl')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai_kediri && $currentDate <= $bundling[0]->tgl_tiket_selesai_kediri;    

//     $kidsDash = Tiket::where('id_tiket',$kds)->get();
//     $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai_kediri && $currentDate <= $kidsDash[0]->tgl_tiket_selesai_kediri; 
    
//     $currentDateRun = date('Y-m-d');      
//     $lokRun = Lokasi_run::where('kode_lokasi',$kota)->get();
//     $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;


//     return view('home.kediri',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','showButton','showButton2','showButton3','showButton4','kota','buka'));
// });

// Route::get('/madiun', function () {
//     $kode = 'ELyx4';
//     $kode2 = 'KBch0';
//     $kode3 = 'q72VN';
//     $kode4 = 'SNS3O';
//     $kode5 = 'QuovV';
//     $kode6 = 'ptBPk';
//     $kode7 = 'MLqi4';
//     $tik = 'sRkD9';
//     $reg = 'RMbaT';
//     $bundl ='lDHcl';
//     $kds ='M3ys7';
//     $super ='U1Qwm';
//     $kota ='MN';

//     $tiket_pre = Tiket::where('id_tiket','sRkD9')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton = $currentDate >= $tiket_pre[0]->tgl_tiket_mulai_madiun && $currentDate <= $tiket_pre[0]->tgl_tiket_selesai_madiun;   
//     $showButton1Jumlah = Peserta::where('lokasi_run','MN')->where('pembayaran','Paid')->count();
//     $showButtonJumlah = $showButton1Jumlah <= 1;
//     $reguler = Tiket::where('id_tiket','RMbaT')
//         ->get();
//         // Ambil tanggal saat ini
//         $currentDate = date('Y-m-d');        
//     $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai_madiun && $currentDate <= $reguler[0]->tgl_tiket_selesai_madiun;    


//     $bundling = Tiket::where('id_tiket','lDHcl')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai_madiun && $currentDate <= $bundling[0]->tgl_tiket_selesai_madiun;    

//     $kidsDash = Tiket::where('id_tiket',$kds)->get();
//     $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai_madiun && $currentDate <= $kidsDash[0]->tgl_tiket_selesai_madiun; 

//     $superDash = Tiket::where('id_tiket',$super)->get();
//     $showButton5 = $currentDate >= $superDash[0]->tgl_tiket_mulai_madiun && $currentDate <= $superDash[0]->tgl_tiket_selesai_madiun;
    
//     $currentDateRun = date('Y-m-d');      
//     $lokRun = Lokasi_run::where('kode_lokasi',$kota)->get();
//     $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;


//     return view('home.madiun',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','tik','reg','bundl','tiket_pre','reguler','bundling','kds','super','showButton','showButton2','showButton3','showButton4','showButton5','showButtonJumlah','kota','buka'));
// });

// Route::get('/surabaya', function () {
//     $kode = 'ELyx4';
//     $kode2 = 'KBch0';
//     $kode3 = 'q72VN';
//     $kode4 = 'SNS3O';
//     $kode5 = 'QuovV';
//     $kode6 = 'ptBPk';
//     $kode7 = 'MLqi4';
//     $kodeHM = 'BSFm4';
//     $tik = 'sRkD9';
//     $reg = 'RMbaT';
//     $bundl ='lDHcl';
//     $kds ='M3ys7';
//     $super ='U1Qwm';
//     $kota ='SB';

//     $tiket_pre = Tiket::where('id_tiket','sRkD9')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDatePre = date('Y-m-d H:i:s');        
//     $showButton = $currentDatePre >= $tiket_pre[0]->tgl_tiket_mulai_surabaya && $currentDatePre <= $tiket_pre[0]->tgl_tiket_selesai_surabaya;    

//     $reguler = Tiket::where('id_tiket','RMbaT')
//         ->get();
//         // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton2 = $currentDate >= $reguler[0]->tgl_tiket_mulai_surabaya && $currentDate <= $reguler[0]->tgl_tiket_selesai_surabaya;    


//     $bundling = Tiket::where('id_tiket','lDHcl')
//                 ->get();
//     // Ambil tanggal saat ini
//     $currentDate = date('Y-m-d');        
//     $showButton3 = $currentDate >= $bundling[0]->tgl_tiket_mulai_surabaya && $currentDate <= $bundling[0]->tgl_tiket_selesai_surabaya;    

//     $kidsDash = Tiket::where('id_tiket',$kds)->get();
//     $showButton4 = $currentDate >= $kidsDash[0]->tgl_tiket_mulai_surabaya && $currentDate <= $kidsDash[0]->tgl_tiket_selesai_surabaya;   

    
//     $superDash = Tiket::where('id_tiket',$super)->get();
//     $showButton5 = $currentDate >= $superDash[0]->tgl_tiket_mulai_surabaya && $currentDate <= $superDash[0]->tgl_tiket_selesai_surabaya;


    
//     $currentDateRun = date('Y-m-d');      
//     $lokRun = Lokasi_run::where('kode_lokasi',$kota)->get();
//     $buka = $currentDateRun >= $lokRun[0]->tiket_buka && $currentDateRun <= $lokRun[0]->tiket_tutup;


//     return view('home.surabaya',compact('kode','kode2','kode3','kode4','kode5','kode6','kode7','kodeHM','tik','reg','bundl','tiket_pre','reguler','bundling','kds','super','showButton','showButton2','showButton3','showButton4','showButton5','kota','buka'));
// });

Route::get('/closed', function () {
    return view('errors.closed');
});

Route::get('/coming_soon', function () {
    return view('errors.coming');
});

Route::get('/refund_policy', function () {
    return view('home.refund_policy');
});

Route::get('/terms_and_conditions', function () {
    return view('home.terms_and_conditions');
});

Route::get('/privacy_policy', function () {
    return view('home.privacy_policy');
});

Route::get('/size', function () {
    return view('home.size');
});
Route::get('/email/BW', function () {
    return view('home.email');
});

Route::get('/cek_voucer', function () {
    return view('home.voucer');
});

Route::get('/run', function () {
    $events = DB::table('company_event')->where('active_company_event',1)->orderBy('date_event','DESC')->get();
    return view('home.list',compact('events'));
});

Route::get('/run/{event_id}', [EventController::class, 'showTickets'])->name('home.event');
Route::get('/order/{tiket}', [EventController::class, 'register'])->name('home.register');
Route::get('/preview/{tiket}', [EventController::class, 'preview'])->name('home.preview');
Route::get('/get-kategori-by-umur/{cat}/{umur}', [EventController::class, 'getKategoriByUmur']);
Route::get('/peserta/{event_id}', [EventController::class, 'showPeserta'])->name('home.peserta');
Route::get('/registrasi', [RegistrasiController::class, 'registrasi']);
Route::get('/checkout/success/{transaction}',[RegistrasiController::class, 'success'])->name('checkout-success');






Route::get('/registrasiPree/{kode}', [RegistrasiController::class, 'registrasiPree'])->name('registrasiPree');

Route::get('/registrasiPresale/{kode}/{kd}/{kota}', [RegistrasiController::class, 'registrasiPresale'])->name('registrasiPresale');

Route::get('/registrasiPresaleKomunitas/{kode}/{kd}/{kota}', [RegistrasiController::class, 'registrasiPresaleKomunitas'])->name('registrasiPresaleKomunitas');

Route::get('/kabupatens/{provinsiId}', [RegistrasiController::class, 'getKabupatens']);
Route::get('/get-items/{kode}', [RegistrasiController::class, 'getItems']);
Route::get('/get-items2/{kode}/{kd}/{kota}', [RegistrasiController::class, 'getItems2']);

Route::post('/registrasi/run', [RegistrasiController::class, 'saveRegistrasi'])->name('registrasirun');
Route::post('/registrasi/runKomunitas', [RegistrasiController::class, 'saveRegistrasikomunitas'])->name('registrasirunKomunitas');
Route::post('/registrasi/runKomunitas1', [RegistrasiController::class, 'saveRegistrasikomunitas1'])->name('registrasirunKomunitas1');
Route::get('/registrasiPreview/{kode}', [RegistrasiController::class, 'registrasiPreview'])->name('registrasiPreview');
Route::post('/notification', [RegistrasiController::class, 'notificationHandler'])->name('notification');

Route::get('/certificates/verify/{id}', [RegistrasiController::class, 'verify'])->name('certificates.verify');


Route::get('qr-code', [QRCodeController::class, 'index']);
Route::get('generate-pdf/{kode}', [PDFController::class, 'generatePDF']);

Route::get('generateQr/{kode}', [RegistrasiController::class, 'generateQr']);

Route::get('/mail/send/{koders}', [RegistrasiController::class, 'kirimEmail']);

Route::post('/midtrans-notification', [PaymentController::class, 'handleNotification']);


Route::post('/cek/voucer', [RegistrasiController::class, 'cekVoucer'])->name('cekVoucer');
Route::get('/komunitas/{kode}', [RegistrasiController::class, 'listKomunitas'])->name('listKomunitas');
Route::get('/registrasiKomunitas/{kode}/{kd}/{kota}/{voucher}', [RegistrasiController::class, 'registrasiKomunitas'])->name('registrasiKomunitas');
Route::get('/registrasiKomunitasPreview/{id}/{kode}/{pay}', [RegistrasiController::class, 'registrasiKomunitasPreview'])->name('registrasiKomunitasPreview');


Route::group(['middleware'=>'auth'],function()
{
    Route::get('home',function()
    {
        return view('dashboard.home');
    });

});


Auth::routes();

Route::group(['namespace' => 'App\Http\Controllers\Auth'],function()
{
    // -----------------------------login----------------------------------------//
    Route::controller(LoginController::class)->group(function () {
        Route::get('/login', 'login')->name('login');
        Route::post('/login', 'authenticate');
        Route::get('/logout', 'logout')->name('logout');
        Route::get('logout/page', 'logoutPage')->name('logout/page');
    });





    // ------------------------------ register ----------------------------------//
    Route::controller(RegisterController::class)->group(function () {
        // Route::get('/registerRun', 'register')->name('registerRun');
        Route::get('/registerAdmin', 'registerAdmin')->name('registerAdmin');
        // Route::post('/register','storeUser')->name('register');    
    });

    // ----------------------------- forget password ----------------------------//
    Route::controller(ForgotPasswordController::class)->group(function () {
        Route::get('forget-password', 'getEmail')->name('forget-password');
        Route::post('forget-password', 'postEmail')->name('forget-password');    
    });

    // ----------------------------- reset password -----------------------------//
    Route::controller(ResetPasswordController::class)->group(function () {
        Route::get('reset-password/{token}', 'getPassword');
        Route::post('reset-password', 'updatePassword');    
    });
});

Route::group(['namespace' => 'App\Http\Controllers'],function()
{
    // -------------------------- main dashboard ----------------------//
    Route::controller(HomeController::class)->group(function () {
        Route::get('/home', 'index')->middleware('auth')->name('home');
        Route::get('/homeEvent/{id}', 'event')->middleware('auth')->name('homeEvent');
        Route::get('/homeMain/{comp}/{id}', 'homeMain')->middleware('auth')->name('homeMain');
    });

     // -------------------------- peserta ----------------------//
     Route::middleware('auth')->prefix('peserta/')->group(function () {
        Route::controller(PesertaController::class)->group(function () {
            Route::get('pesertalist/{id}', 'pesertaList')->name('peserta/pesertalist');
            Route::get('racepacklist/{id}', 'racepacklist')->name('peserta/racepacklist');
            Route::get('search/{id}', 'search')->name('search');
            Route::get('gudang_Sb/{id}', 'gudangSb')->name('gudang');
            Route::get('grafik/{id}', 'grafikReport')->name('peserta/grafik');
            Route::get('grafikDetail/{kota}/{kode}', 'grefikReport1')->name('peserta/grafikDetail');
            Route::get('email/{id}', 'emailSB')->name('email');
            Route::get('kirimEmail/{kode_id}', 'kirimEmail')->name('peserta/kirimEmail');
           
            Route::get('race_bw', 'raceBw')->name('race_pack/banyuwangi');
            Route::get('race_bw/{kode}', 'raceBwKonfirmasi')->name('race_packBW/konfirmasi');
            Route::get('/konfirmasiDiterima/{id}', 'konfirmasiDiterima')->name('konfirmasiDiterima'); // tambahan

            // setting admin
            Route::get('participantlistEvent/{id}', 'participantlistEvent')->name('peserta/participantlistEvent');
            Route::post('participantSave', 'saveRecordParticipantCompany')->name('participantCompanySave'); 
            Route::post('participantupdate', 'participantCompanyUpdateRecord')->name('participantCompanyUpdate'); //update participant record
            Route::post('participantdelete', 'participantCompanyDeleteRecord')->name('participantCompanyDel'); // delete participant record

            
            Route::get('generate-bib/{id}', 'generateBibNumbers')->name('generate.bib');
            Route::get('export/{kode_id}', 'pesertaExport')->name('peserta/export');


            // Route::get('list', 'pesertaList')->name('peserta/list/banyuwangi');
            Route::get('listMadiun', 'pesertaMadiun')->name('peserta/list/madiun');
            Route::get('listKediri', 'pesertaKediri')->name('peserta/list/kediri');
            Route::get('listSurabaya', 'pesertaSurabaya')->name('peserta/list/surabaya');
             Route::post('save', 'saveRecordPeserta')->name('peserta/save'); // add new Kategori Peserta
            
            Route::get('pesertaimport', 'importGet')->name('peserta.import');
            Route::post('pesertaimport', 'import')->name('peserta.import1');
            Route::post('pesertaimportBib', 'importBib')->name('peserta.importbib');
            Route::post('pesertaimporthasilrace', 'importHasilrace')->name('peserta.importhasilrace');

            // lokasi banyuwangi
             

            // lokasi kediri
            Route::get('race_kd', 'raceKd')->name('race_pack/kediri');
            Route::get('race_kd/{kode}/{lok}', 'raceKdKonfirmasi')->name('race_packKD/konfirmasi');
            Route::get('/searchKD', 'searchKD')->name('searchKD');

            // lokasi madiun
            Route::get('race_mn', 'raceMn')->name('race_pack/madiun');
            Route::get('race_mn/{kode}/{lok}', 'raceMnKonfirmasi')->name('race_packMN/konfirmasi');
            Route::get('/searchMN', 'searchMN')->name('searchMN');

            // lokasi surabaya
            Route::get('race_sb', 'raceSb')->name('race_pack/surabaya');
            Route::get('race_sb/{kode}/{lok}', 'raceSbKonfirmasi')->name('race_packSB/konfirmasi');
            Route::get('/searchSB', 'searchSB')->name('searchSB');
           
            Route::get('/konfirmasi/{id}', 'konfirmasiKehadiran2')->name('konfirmasiKehadiran2');
           
            Route::get('/email/bw', 'emailBW')->name('email/bw');
            Route::get('/email/kd', 'emailKD')->name('email/kd');
            Route::get('/email/mn', 'emailMN')->name('email/mn');
            

            Route::get('gudang_bw', 'gudangBw')->name('gudang/banyuwangi');
            Route::get('gudang_Kd', 'gudangKd')->name('gudang/kediri');
            Route::get('gudang_Mn', 'gudangMn')->name('gudang/madiun');
            

            Route::get('addPeserta', 'addpeserta')->name('peserta/add');
            

            

        });
    });


      // -------------------------- Tiket ----------------------//
      Route::middleware('auth')->prefix('tiket/')->group(function () {
        Route::controller(TiketController::class)->group(function () {
            Route::get('list', 'tiketList')->name('tiket/list');
            Route::post('save', 'saveRecordtiket')->name('tiketSave'); // add new tiket record 
            Route::post('update', 'tiketUpdateRecord')->name('tiketUpdate'); //update tiket record
            Route::post('deletess', 'tiketDeleteRecord')->name('tiketDel'); // delete tiket record

            Route::get('listHarga', 'hargaTiketlist')->name('harga/tiket/list');
            Route::post('saveHarga', 'saveRecordharga')->name('hargaTiketsave'); // add new harga tiket record 
            Route::post('updateHarga', 'tiketHargaUpdateRecord')->name('tiketHargaupdate'); //update tiket record

            Route::get('kategorirunlist', 'kategoryRunList')->name('kategori_run/list');
            Route::post('kategorirunSave', 'saveRecordkategorirun')->name('kategorirunSave'); // add new Category Event record 
            Route::post('updateKatrun', 'kategorirunUpdateRecord')->name('kategorirunUpdate'); //update category Event record
            Route::post('delete', 'kategorirunDeleteRecord')->name('kategorirunDelete'); // delete category Event record
        
            Route::get('listLokasi', 'lokasiList')->name('lokasi/list'); 
            Route::post('saveLokasi', 'saveRecordlokasi')->name('lokasiSave'); // add new location event record 
            Route::post('updateLokasi', 'lokasiUpdateRecord')->name('lokasiUpdate'); //update tiket record
            Route::post('deleteLokasi', 'lokasiDeleteRecord')->name('lokasiDelete'); // delete tiket record

            
            Route::get('kategori/peserta', 'kategoriPeserta')->name('kategori/peserta');
            Route::post('saveKategoripeserta', 'saveRecordkategoriPeserta')->name('kategoriPesertaSave'); // add new Kategori Peserta
            Route::post('updateKategoripeserta', 'kategoriPesertaUpdateRecord')->name('KategoripesertaUpdate'); //update Kategori Peserta record
            Route::post('deleteKategoripeserta', 'kategoriPesertaDeleteRecord')->name('KategoripesertaDelete'); // delete Kategori Peserta record

            Route::get('voucer', 'voucer')->name('voucer'); 
            Route::post('voucerSave', 'saveRecordvoucer')->name('voucerSave'); // add new tiket record 

        });
    });
    

    // -------------------------- pages ----------------------//
    Route::controller(AccountController::class)->group(function () {
        Route::get('page/account/list', 'accountList')->middleware('auth')->name('accountList');
        Route::post('page/account/save', 'accountSaveRecord')->middleware('auth')->name('accountsave');
        Route::post('page/account/edit', 'accountEditRecord')->middleware('auth')->name('accountEdit');
        Route::get('page/account/{user_id}', 'profileDetail')->middleware('auth')->name('profileDetail');
        
    });



       

         // -------------------------- report ----------------------//
        Route::middleware('auth')->prefix('report/')->group(function () {
        Route::controller(ReportController::class)->group(function () {
            Route::get('banyuwangi', 'reportList')->name('report/banyuwangi');
        

            });
        });

     
          // -------------------------- Setting Admin ----------------------//
        
        Route::controller(SettingAdminController::class)->group(function () {
            Route::middleware('auth')->group(function () {    
                Route::prefix('admin')->group(function () {
                    Route::prefix('company')->controller(SettingAdminController::class)->group(function () {
                        Route::get('company', 'companyList')->name('admin/company/company');
                        Route::get('company/{id}', 'companyListById')->name('admin/company/companyById');
                        Route::post('save', 'saveRecordcompany')->name('companySave'); // add company record 
                        Route::post('update', 'companyUpdateRecord')->name('companyUpdate'); //update company record
                        Route::post('delete', 'companyDeleteRecord')->name('companyDel'); // delete company record

                    });

                    Route::prefix('ticketKriteria')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'ticketKriteriaList')->name('admin/ticketKriteria/list');
                        Route::post('save', 'saveRecordticketKriteria')->name('ticketKriteriaSave'); // add ticket Kriteria record 
                        Route::post('update', 'ticketKriteriaUpdateRecord')->name('ticketKriteriaUpdate'); //update ticket Kriteria record
                        Route::post('delete', 'ticketKriteriaDeleteRecord')->name('ticketKriteriaDel'); // delete ticket Kriteria record

                    });

                    
                       
                    Route::prefix('event')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list/{comp}/{id}', 'eventListById')->name('admin/company/eventById');
                        Route::get('event', 'eventList')->name('admin/company/event');
                        Route::post('save', 'saveRecordevent')->name('eventSave'); // add event record 
                        Route::post('update', 'eventUpdateRecord')->name('eventUpdate'); //update event record
                        Route::post('delete', 'eventDeleteRecord')->name('eventDel'); // delete event record

                    });

                    Route::prefix('kategoryEvent')->controller(SettingAdminController::class)->group(function () {
                        Route::get('event', 'kategoriEventList')->name('kategoriEventlist');
                        Route::post('save', 'saveRecordkategoriEvent')->name('kategoriEventSave'); // add kategoriEvent record 
                        Route::post('update', 'kategoriEventUpdateRecord')->name('kategoriEventUpdate'); //update kategoriEvent record
                        Route::post('delete', 'kategoriEventDeleteRecord')->name('kategoriEventDel'); // delete kategoriEvent record

                    });

                    Route::prefix('gender')->controller(SettingAdminController::class)->group(function () {
                        Route::get('gender', 'gendertList')->name('genderlist');
                        Route::post('save', 'saveRecordgender')->name('genderSave'); // add gender record 
                        Route::post('update', 'genderUpdateRecord')->name('genderUpdate'); //update gender record
                        Route::post('delete', 'genderDeleteRecord')->name('gendertDel'); // delete gender record

                    });

                    Route::prefix('participant')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'participantlist')->name('participantlist');
                        Route::post('save', 'saveRecordparticipant')->name('participantSave'); // add participant record 
                        Route::post('update', 'participantUpdateRecord')->name('participantUpdate'); //update participant record
                        Route::post('delete', 'gparticipantDeleteRecord')->name('participantDel'); // delete participant record

                    });

                    Route::prefix('categoryTicket')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'categoryTicketList')->name('admin/categoryTicket/list');
                        Route::post('save', 'saveRecordcategoryTicket')->name('categoryTicketSave'); // add categoryTicket record 
                        Route::post('update', 'categoryTicketUpdateRecord')->name('categoryTicketUpdate'); //update categoryTicket record
                        Route::post('delete', 'categoryTicketDeleteRecord')->name('categoryTicketDel'); // delete categoryTicket record

                    });

                    Route::prefix('ticket')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list/{id}', 'ticketList')->name('admin/ticket/list');
                        Route::post('save', 'saveRecordticket')->name('admin/ticket/save'); // add ticket record 
                        Route::post('update', 'ticketUpdateRecord')->name('admin/ticket/update'); //update ticket record
                        Route::post('delete', 'ticketDeleteRecord')->name('admin/ticket/delete'); // delete ticket record

                    });

                    Route::prefix('sizeJersey')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list/{id}', 'sizeJerseyList')->name('admin/sizeJersey/list');
                        Route::post('save', 'saveRecordsizeJersey')->name('admin/sizeJersey/save'); // add sizeJersey record 
                        Route::post('update', 'sizeJerseyUpdateRecord')->name('admin/sizeJersey/update'); //update sizeJersey record
                        Route::post('delete', 'sizeJerseyDeleteRecord')->name('admin/sizeJersey/delete'); // delete sizeJersey record

                    });

                    Route::prefix('ic')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'icList')->name('admin/ic/list');
                        Route::post('save', 'saveRecordic')->name('admin/ic/save'); // add ic record 
                        Route::post('update', 'icUpdateRecord')->name('admin/ic/update'); //update ic record
                        Route::post('delete', 'icDeleteRecord')->name('admin/ic/delete'); // delete ic record

                    });

                    Route::prefix('blood')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'bloodList')->name('admin/blood/list');
                        Route::post('save', 'saveRecordblood')->name('admin/blood/save'); // add blood record 
                        Route::post('update', 'bloodUpdateRecord')->name('admin/blood/update'); //update blood record
                        Route::post('delete', 'bloodDeleteRecord')->name('admin/blood/delete'); // delete blood record

                    });

                    Route::prefix('log')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'logList')->name('admin/log/list');
                        
                    });
                
                    Route::prefix('user')->controller(SettingAdminController::class)->group(function () {
                        Route::get('list', 'userList')->name('admin/user/list');
                        Route::post('save', 'saveRecorduser')->name('admin/user/save'); // add user record 
                        Route::post('update', 'userUpdateRecord')->name('admin/user/update'); //update user record
                        Route::post('delete', 'userDeleteRecord')->name('admin/user/delete'); // delete user record

                    });

               


                });
            });
       });





    
});


