@extends('layouts.master')
@section('content')
    <!-- Page-content -->
    <div class="group-data-[sidebar-size=lg]:ltr:md:ml-vertical-menu group-data-[sidebar-size=lg]:rtl:md:mr-vertical-menu group-data-[sidebar-size=md]:ltr:ml-vertical-menu-md group-data-[sidebar-size=md]:rtl:mr-vertical-menu-md group-data-[sidebar-size=sm]:ltr:ml-vertical-menu-sm group-data-[sidebar-size=sm]:rtl:mr-vertical-menu-sm pt-[calc(theme('spacing.header')_*_1)] pb-[calc(theme('spacing.header')_*_0.8)] px-4 group-data-[navbar=bordered]:pt-[calc(theme('spacing.header')_*_1.3)] group-data-[navbar=hidden]:pt-0 group-data-[layout=horizontal]:mx-auto group-data-[layout=horizontal]:max-w-screen-2xl group-data-[layout=horizontal]:px-0 group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:ltr:md:ml-auto group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:rtl:md:mr-auto group-data-[layout=horizontal]:md:pt-[calc(theme('spacing.header')_*_1.6)] group-data-[layout=horizontal]:px-3 group-data-[layout=horizontal]:group-data-[navbar=hidden]:pt-[calc(theme('spacing.header')_*_0.9)]">
        <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
            <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
                <div class="grow">
                    <h5 class="text-16">Race Pack {{$lok[0]->event_name}}</h5>
                </div>
                <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                    <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                        <a href="#!" class="text-slate-400 dark:text-zink-200">Peserta</a>
                    </li>
                    <li class="text-slate-700 dark:text-zink-100">
                        Daftar Peserta {{$lok[0]->event_name}}
                    </li>
                </ul>
            </div>

     
         

            <div class="card">
                <div class="card-body">
                    <div class="flex items-center">
                        <h6 class="text-15 grow">Peserta </h6>
                      
                    
                    </div>
                    <br>
                    <table id="alternativePagination" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">No</th>
                                <th hidden>ID</th>
                                <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">Loket</th>
                                <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">Bib Number</th>
   
                                <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">Full Name</th>
                                <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">Jenis Kelamin</th>

                                <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">Size Jersey</th>

                               
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($peserta as $key => $value)
                            @if($value->package == 1)
                                    @php
                                    $kat = 'Fan Walk'
                                    @endphp
                                @elseif($value->package == 2)
                                    @php
                                    $kat = '5K'
                                    @endphp
                                @elseif($value->package == 3)
                                    @php
                                    $kat = '10K'
                                    @endphp
                                @elseif($value->package == 4)
                                    @php
                                    $kat = 'HM'
                                    @endphp
                                @elseif($value->package == '5A')
                                    @php
                                    $kat = 'Kids Dash 400M'
                                    @endphp
                                @else
                                    @php
                                    $kat = 'Kids Dash 200'
                                    @endphp
                                @endif   

                                <tr>
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">{{ ++$key }}</td>
                                    <td class="id_update" hidden>{{ $value->order_id }}</td>
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">Loket {{ $value->loket }}</td>
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">{{ $value->bib_number }}</td>
                  
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">{{ $value->full_name }}</td>
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">{{ $value->jenis_kelamin }}</td>
                                    @if($value->package !=='ELyx4')
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">{{ $value->tshirt_size }}</td>
                                    @else
                                    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">-</td>
                                    @endif
                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- End Page-content -->


    
  

@section('script')
    {{-- update js --}}
    <script>
        setInterval(function(){
            location.reload();  // Untuk me-refresh seluruh halaman
        }, 2000);  // 1000 ms = 1 detik
    </script>
   
@endsection
@endsection
