<!DOCTYPE html>
<html lang="en" class="overflow-x-hidden scroll-smooth group" data-mode="light" dir="ltr">

<head>

    <meta charset="utf-8">
    <title>East Java running Fest</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta content="Minimal Admin & Dashboard Template" name="description">
    <meta content="subjersey" name="author">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- App favicon -->
    <link rel="shortcut icon" href="{{ URL::to('assets/images/EJR-Logo-light_icon.png') }}">
    <!-- Layout config Js -->
    <script src="{{ URL::to('assets/js/layout.js') }}"></script>
    <!-- Icons CSS -->
    
    <!-- StarCode CSS -->
    

    <link rel="stylesheet" href="{{ URL::to('assets/css/starcode2.css') }}">
</head>

<body class="text-base bg-white text-body font-public dark:text-zink-50 dark:bg-zink-800">

    <nav class="fixed inset-x-0 top-0 z-50 flex items-center justify-center h-20 py-3 [&.is-sticky]:bg-white dark:[&.is-sticky]:bg-zink-700 border-b border-slate-200 dark:border-zink-500 [&.is-sticky]:shadow-lg [&.is-sticky]:shadow-slate-200/25 dark:[&.is-sticky]:shadow-zink-500/30 navbar" id="navbar">
        <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto flex items-center self-center w-full">
            <div class="shrink-0">
                <a href="{{URL::to('/')}}">
                    <img src="{{URL::to('assets/images/EJR-Logo-light.png')}}" alt="" class="block h-14 dark:hidden">
                    <img src="{{URL::to('assets/images/EJR-Logo-light.png')}}" alt="" class="hidden h-14 dark:block">
                </a>
            </div>
            <div class="mx-auto">
                <ul id="navbar7" class="absolute inset-x-0 z-20 items-center hidden py-3 bg-white shadow-lg dark:bg-zink-600 dark:md:bg-transparent md:z-0 navbar-menu rounded-b-md md:shadow-none md:flex top-full ltr:ml-auto rtl:mr-auto md:relative md:bg-transparent md:rounded-none md:top-auto md:py-0">
                    <li>
                        <a href="{{URL::to('/#home')}}" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500 ">Home</a>
                    </li>
                    <li>
                        <a href="{{URL::to('/#features')}}" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Our Event</a>
                    </li>
                    <li>
                        <a href="{{URL::to('/#about')}}" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">About Us</a>
                    </li>
                    <li>
                        <a href="{{URL::to('/#pricing')}}" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Kategori Lari</a>
                    </li>
                    <li>
                        <a href="{{URL::to('/story')}}" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Our Story</a>
                    </li>
                    <li>
                        <a href="{{URL::to('/#contact')}}" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500">Kontak</a>
                    </li>
                    <li>
                        <a href="#peserta" class="block md:inline-block px-4 md:px-3 py-2.5 md:py-0.5 text-15 font-medium text-slate-800 transition-all duration-300 ease-linear hover:text-custom-500 [&.active]:text-custom-500 dark:text-zink-100 dark:hover:text-custom-500 dark:[&.active]:text-custom-500 active">Peserta</a>
                    </li>
                </ul>
            </div>
            <div class="flex gap-2">
                <div class="ltr:ml-auto rtl:mr-auto md:hidden navbar-toggale-button">
                    <button type="button" class="flex items-center  justify-center size-[37.5px] p-0 text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20"><i data-lucide="menu"></i></button>
                </div>
            
            </div>
        </div>
    </nav>
    <div id="layoutSidenav_content">
        <main>
        {!! Toastr::message() !!}
        @yield('content')
        </main>
    </div>

    @yield('script')
    
    <script src="{{ URL::to('assets/libs/choices.js/public/assets/scripts/choices.min.js') }}"></script>
    <script src="{{ URL::to('assets/libs/%40popperjs/core/umd/popper.min.js') }}"></script>
    <script src="{{ URL::to('assets/libs/tippy.js/tippy-bundle.umd.min.js') }}"></script>
    <script src="{{ URL::to('assets/libs/simplebar/simplebar.min.js') }}"></script>
    <script src="{{ URL::to('assets/libs/prismjs/prism.js') }}"></script>
    <script src="{{ URL::to('assets/libs/lucide/umd/lucide.js') }}"></script>
    <script src="{{ URL::to('assets/js/starcode.bundle.js') }}"></script>
    <script src="{{ URL::to('assets/libs/flatpickr/flatpickr.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/pages/landing-onepage.init.js') }}"></script>
    <!--apexchart js-->
    <script src="{{ URL::to('assets/libs/apexcharts/apexcharts.min.js') }}"></script>

    <!-- dropzone -->
    <script src="{{ URL::to('assets/libs/dropzone/dropzone-min.js') }}"></script>
   
    <!--product create init js-->
    <script src="{{ URL::to('assets/js/pages/apps-ecommerce-product-create.init.js') }}"></script>
    
    <script src="{{ URL::to('assets/js/datatables/jquery-3.7.0.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/data-tables.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/data-tables.tailwindcss.min.js') }}"></script>
    <!--buttons dataTables-->
    <script src="{{ URL::to('assets/js/datatables/datatables.buttons.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/jszip.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/datatables.init.js') }}"></script>

    <script src="{{ URL::to('assets/js/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::to('assets/js/datatables/datatables.init.js') }}"></script>
    <script>
        document.addEventListener("contextmenu", function(e){
            e.preventDefault();
        }, false);
    </script>

</body>    

</html>