@extends('layoutsutama.master3')
@section('content')
        <!-- dari sini -->

       
        <section class="py-24 bg-gradient-to-br from-slate-300 to-white min-h-screen">
            <div class="max-w-7xl mx-auto px-4">
                <!-- <div class="flex justify-center w-full">
            <div class="flex w-1/2 gap-6"> -->
                <!-- Judul -->
                <div class="text-center mb-12">
                                <h2 class="text-3xl font-bold">Pendaftaran</h2>
                                <p class="text-gray-600 mt-2">Harap lengkapi data pribadi Anda.</p>
                            </div>

                <!-- Kontainer -->
                <div class="flex justify-center">
                    
                    <div class="w-full md:w-[60%] bg-white rounded-2xl shadow-lg p-8 space-y-6">
                            
                        <!-- Judul Tiket -->
                        <div class="border-b pb-4">
                            <h4 class="text-xl font-bold">{{$tik[0]->ticket_name}} ({{$tik[0]->category_ticket_name}})</h4>
                            <p class="text-sm text-gray-600">{{$tik[0]->event_name}}</p>
                        </div>

                        <!-- Form -->
                        <form action="{{route('registrasirun')}}" method="POST" class="space-y-4" enctype="multipart/form-data">
                            @csrf
                            
                            <h4 class="text-sm text-gray-600">Informasi Kontak</h4>    
                            <div class="grid grid-cols-1 md:grid-cols-1 gap-4 py-3">
                                <div>
                                    <label class="block text-sm font-medium">Nama Lengkap <span class="text-red-500">*</span></label>
                                    <input type="text" name="full_name" id="full_name" class="form-input w-full" placeholder="Masukkan Nama Lengkap">
                                    <input type="hidden" name="order_id" id="order_id" class="form-input w-full" value="{{$trs}}">
                                     <input type="hidden" name="eve" id="eve" class="form-input w-full" value="{{$eve}}">
                                    <p class="text-red-500 text-sm hidden" id="err_full_name">Wajib diisi</p>
                                </div>
                            </div>    
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium">Email <span class="text-red-500">*</span></label>
                                    <input type="email" name="email" id="email" class="form-input w-full" placeholder="Masukkan Email">
                                    <p class="text-red-500 text-sm hidden" id="err_email">Wajib diisi</p>
                                    <p id="error_email" class="text-red-500 text-sm hidden">Email wajib diisi.</p>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium">No Telp/WhatsApp <span class="text-red-500">*</span></label>
                                    <input type="text" name="phone" id="phone" class="form-input w-full" placeholder="Masukkan No Telp/WhatsApp">
                                    <p id="error_phone" class="text-red-500 text-sm hidden">No Telp wajib diisi.</p>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-1 gap-4 py-3">
                                <div>
                                    <label class="block text-sm font-medium">Alamat <span class="text-red-500">*</span></label>
                                    <textarea name="alamat" id="alamat" class="form-input w-full resize-none" rows="3" placeholder="Masukkan Alamat"></textarea>
                                    <p id="error_alamat" class="text-red-500 text-sm hidden">Alamat wajib diisi.</p>
                                </div>
                            </div>     
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium">Provinsi<span class="text-red-500">*</span></label>
                                    <select name="provinsi" id="provinsi" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Provinsi</option>
                                        @foreach($prvinsi as $key => $aks)
                                            <option value="{{ $aks->id_prov }}">{{ $aks->nama }}</option>
                                        @endforeach 
                                    </select>
                                    <p id="error_provinsi" class="text-red-500 text-sm hidden">provinsi wajib diisi.</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">Kab/Kota<span class="text-red-500">*</span></label>
                                    <select name="kabupaten" id="kabupaten" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Kota</option>
                                         @foreach($kab as $key => $ak)
                                            <option value="{{ $ak->id }}">{{ $ak->nama }}</option>
                                        @endforeach 
                                    </select>
                                    <p id="error_kabupaten" class="text-red-500 text-sm hidden">Kabupaten wajib diisi.</p>
                                </div>
                                 <div>
                                    <label class="block text-sm font-medium">Negara <span class="text-red-500">*</span></label>
                                    <select name="negara" id="negara" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Negara</option>
                                         @foreach($cntry as $key => $ak)
                                            <option value="{{ $ak->id_country }}">{{ $ak->country_name }}</option>
                                        @endforeach 
                                    </select>
                                    <p id="error_negara" class="text-red-500 text-sm hidden">Negara wajib diisi.</p>
                                </div>
                            </div>
                            
                            <br>   
                            <b class="text-sm text-gray-600">Detail Peserta</b>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 py-2">
                                <div>
                                    <label class="block text-sm font-medium">Nama Depan <span class="text-red-500">*</span></label>
                                    <input type="text" name="first_name" id="first_name" class="form-input w-full" placeholder="Masukkan Nama Depan">
                                    <p id="error_first_name" class="text-red-500 text-sm hidden">Nama depan wajib diisi.</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">Nama Belakang <span class="text-red-500">*</span></label>
                                    <input type="text" name="last_name" id="last_name" class="form-input w-full" placeholder="Masukkan Nama Belakang">
                                    <p id="error_last_name" class="text-red-500 text-sm hidden">Nama belakang wajib diisi.</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">Nama BIB <span class="text-red-500">*</span></label>
                                    <input type="text" name="bib_name" id="bib_name" class="form-input w-full" placeholder="Masukkan BIB Name">
                                      <p id="error_bib_name" class="text-red-500 text-sm hidden">Nama BIB wajib diisi.</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">Jenis Kelamin <span class="text-red-500">*</span></label>
                                    <select name="jenis_kelamin" id="jenis_kelamin" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Jenis Kelamin</option>
                                         @foreach($gndr as $key => $ak)
                                            <option value="{{ $ak->gender_name }}">{{ $ak->gender_name }}</option>
                                        @endforeach 
                                    </select>
                                    <p class="text-red-500 text-sm hidden" id="err_jenis_kelamin">Jenis kelamin wajib diisi</p>
                                </div>
                                 <div>
                                    <label class="block text-sm font-medium">Jenis Nomor Identitas <span class="text-red-500">*</span></label>
                                    <select name="jenis_no_identitas" id="jenis_no_identitas" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Jenis No Identitas</option>
                                        @foreach($nik as $key => $ak)
                                            <option value="{{ $ak->name_ic }}">{{ $ak->name_ic }}</option>
                                        @endforeach 
                                    </select>
                                      <p class="text-red-500 text-sm hidden" id="err_jenis_no_identitas">Jenis Nomor Identitas wajib diisi</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">Identitas Nomor Nasional <span class="text-red-500">*</span></label>
                                    <input type="text" name="dokumen_id" id="dokumen_id" class="form-input w-full" placeholder="Masukkan Identity Number">
                                    <p class="text-red-500 text-sm hidden" id="err_dokumen_id">Identitas Nomor national wajib diisi</p>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium">Golongan Darah <span class="text-red-500">*</span></label>
                                    <select name="blood_tipe" id="blood_tipe" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Golongan Darah</option>
                                         @foreach($bld as $key => $ak)
                                            <option value="{{ $ak->name_blood }}">{{ $ak->name_blood }}</option>
                                        @endforeach 
                                    </select>
                                     <p class="text-red-500 text-sm hidden" id="err_blood_tipe">Golongan darah wajib diisi</p>
                                </div>
                                @php
                                    $ageOf = $ageMin;
                                    $ageUpTo = $ageMax;
                                    
                                @endphp
                                <div>
                                    <label class="block text-sm font-medium">Tanggal Lahir <span class="text-red-500">*</span></label>
                                    <input type="date" id="tanggal_lahir" name="tanggal_lahir" class="form-input w-full border border-gray-300 rounded mt-1">
    
                                    <p id="warningumur" class="text-red-600 text-sm mt-2 hidden">Umur tidak sesuai ketentuan</p>
                                    <p class="text-red-500 text-sm hidden" id="err_tanggal_lahir">Tanggal lahir wajib diisi</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">Kategori<span class="text-red-500">*</span></label>
                                    <select name="category" id="category" class="select2 form-select w-full">
                                    </select>
                                </div>


                                <div>
                                    <label class="block text-sm font-medium">Harga <span class="text-red-500">*</span></label>
                                    <input type="hidden" name="lokasi_run" id="lokasi_run" class="form-input w-full bg-slate-100" value="{{$tik[0]->event_id}}" readonly>
                                    <input type="hidden" name="package" id="package" class="form-input w-full bg-slate-100" value="{{$tik[0]->ticket_name}}" readonly>
                                    <input type="hidden" name="price" id="price" class="form-input w-full bg-slate-100" value="{{$tik[0]->price}}" readonly>
                                    <input type="text" name="price1" id="price1" class="form-input w-full bg-slate-100" value="Rp. {{number_format($tik[0]->price)}}" readonly>
                                </div>

                                @if($tik[0]->jersey != 2)
                                <div>
                                    <label class="block text-sm font-medium">Ukuran Jersey <span class="text-red-500">*</span></label>
                                    <select name="tshirt_size" id="tshirt_size" class="select2 form-select w-full" data-choices="">
                                        <option value="">Pilih Ukuran Jersey</option>
                                         @foreach($sz as $key => $ak)
                                            <option value="{{ $ak->size_jersey }}">{{ $ak->size_jersey }} ({{ $ak->size }})</option>
                                        @endforeach 
                                    </select>
                                    <p class="text-red-500 text-sm hidden" id="err_tshirt_size">Ukuran Jersey wajib diisi.</p>
                                </div>
                                @endif
                                
                            </div>
                            @if($tik[0]->jersey != 2)
                                <p>Ukuran baju yang sudah dipilih tidak dapat ditukar kembali. Desain dan ukuran T-Shirt dapat dilihat <a href="#" data-modal-target="addSizeCart" class="text-xs text-red-600">Disini</a></p>
                            @endif        
                           <br>
                            <h4 class="text-sm text-gray-600">Kontak Darurat</h4>
                            <p class="text-sm text-gray-600 ">isi informasi kontak darurat yang dapat dihubungi</p>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 py-2">
                                <div>
                                    <label class="block text-sm font-medium">Nama Lengkap <span class="text-red-500">*</span></label>
                                    <input type="text" name="emergency_name" id="emergency_name" class="form-input w-full" placeholder="Masukkan Nama lengkap kontak darurat">
                                    <p id="err_emergency_name" class="text-red-500 text-sm hidden">Wajib diisi.</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium">No Handphone <span class="text-red-500">*</span></label>
                                    <input type="text" name="telp_emergency" id="telp_emergency" class="form-input w-full" placeholder="Masukkan Nomor Aktif kontak darurat">
                                    <p id="err_telp_emergency" class="text-red-500 text-sm hidden">Wajib diisi.</p>
                                </div>
                              
                                <div>
                                    <label class="block text-sm font-medium">Hubungan/Relasi<span class="text-red-500">*</span></label>
                                    <input type="text" name="relationEmergency" id="relationEmergency" class="form-input w-full" placeholder="Keluarga/Teman/Pasangan/Lainnya">
                                    <p id="err_relationEmergency" class="text-red-500 text-sm hidden">Wajib diisi.</p>
                                </div>
                            </div>
                            <div class="text-center pt-4">
                                <a href="{{ url('/run/'.$ket) }}" class="text-white-500 bg-slate-200 btn hover:text-black-500 hover:bg-slate-200 focus:text-black focus:bg-slate-100 active:text-black-500 active:bg-slate-400 dark:bg-zink-600 dark:hover:bg-red-500/10 dark:focus:bg-red-500/10 dark:active:bg-red-500/10">
                                    Back
                                </a>
                                <button type="submit" id="submitBtn" class="px-6 py-2 bg-sky-500 text-black rounded-lg hover:bg-sky-700">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
           

             <div id="addSizeCart" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
                <div class="w-screen md:w-[40rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Size Chart</h5>
                    <button data-modal-close="addSizeCart" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                              
                                <div class="p-2 text-center">
                                    <img src="{{ URL::to($tik[0]->jersey == 0 ? 'assets/images/SIZECARD.jpg' : 'assets/images/SIZECARD_custom.png') }}" alt="size" >
                                </div>
                                
                                    @if($tik[0]->jersey == 1)
                                    <table class="w-full text-[15px]  border border-gray-300 border-collapse">
                                        <tbody>
                                            @foreach($sz as $tick)
                                                <tr class="border border-gray-300">
                                                    <td class="w-24 font-medium px-2 py-1">
                                                        {{ $tick->size_jersey }}
                                                    </td>
                                                    <td class="w-1 px-3">:</td>
                                                    <td class="px-2 py-1">{{ $tick->size }}</td>
                                                </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                    @endif
                                
                            </div>
                        </div>
                
                </div>
                </div>
            </div>


        </section>



         <!-- sampai sini -->


@section('script')
         <script>
            $(document).ready(function () {
                $('.select2').select2({
                    placeholder: "-- Pilih Opsi --",
                    allowClear: true,
                    width: 'resolve'
                });
            });
        </script>


<script>
    document.addEventListener("DOMContentLoaded", function () {
        const tanggalLahir = document.getElementById("tanggal_lahir");
        const warningUmur = document.getElementById("warningumur");
        const submitBtn = document.getElementById("submitBtn");

        const ageMin = {{ $ageOf }};
        const ageMax = {{ $ageUpTo }};

        //  console.log('Umur min:', ageMin);
        //  console.log('Umur max:', ageMax);

        if (!tanggalLahir || !warningUmur || !submitBtn) {
            console.warn("ID tidak ditemukan. Pastikan 'tanggal_lahir', 'warningumur', dan 'submitBtn' sesuai.");
            return;
        }

        

        function validateForm() {
            const value = tanggalLahir.value;
            const today = new Date();
            const lahir = new Date(value);
            let umur = today.getFullYear() - lahir.getFullYear();
            const bulan = today.getMonth() - lahir.getMonth();

            if (bulan < 0 || (bulan === 0 && today.getDate() < lahir.getDate())) {
                umur--;
            }

            let valid = true;

            // Cek apakah tanggal kosong
            if (!value) {
                tanggalLahir.classList.add("border-red-500");
                warningUmur.textContent = "Tanggal lahir wajib diisi.";
                warningUmur.classList.remove("hidden");
                valid = false;
            } else if (umur < ageMin || umur > ageMax) {
                tanggalLahir.classList.add("border-red-500");
                warningUmur.textContent = `Umur Anda ${umur} tahun. Umur diluar kreteria.`;
                warningUmur.classList.remove("hidden");
                valid = false;
            } else {
                tanggalLahir.classList.remove("border-red-500");
                warningUmur.classList.add("hidden");
            }

            submitBtn.disabled = !valid;
            submitBtn.classList.toggle("opacity-50", !valid);
            submitBtn.classList.toggle("cursor-not-allowed", !valid);
        }

        tanggalLahir.addEventListener("change", validateForm);
        tanggalLahir.addEventListener("blur", validateForm);
    });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const form = document.querySelector("form");
        form.addEventListener("submit", function (e) {
            let isValid = true;

            const fields = [
                { id: "full_name", error: "err_full_name" },
                { id: "email", error: "error_email" },
                { id: "phone", error: "error_phone" },
                { id: "alamat", error: "error_alamat" },
                { id: "first_name", error: "error_first_name" },
                { id: "last_name", error: "error_last_name" },
                { id: "bib_name", error: "error_bib_name" },
                { id: "tanggal_lahir", error: "err_tanggal_lahir" },
                { id: "jenis_no_identitas", error: "err_jenis_no_identitas" },
                { id: "dokumen_id", error: "err_dokumen_id" },
                { id: "provinsi", error: "error_provinsi", isSelect2: true },
                { id: "kabupaten", error: "error_kabupaten", isSelect2: true },
                { id: "negara", error: "error_negara", isSelect2: true },
                { id: "tshirt_size", error: "err_tshirt_size", isSelect2: true },
                { id: "blood_tipe", error: "err_blood_tipe", isSelect2: true },
                { id: "tshirt_size", error: "err_tshirt_size", isSelect2: true },
                { id: "jenis_kelamin", error: "err_jenis_kelamin", isSelect2: true },

                { id: "emergency_name", error: "err_emergency_name" },
                { id: "telp_emergency", error: "err_telp_emergency" },
                { id: "relationEmergency", error: "err_relationEmergency" },
            ];

            fields.forEach(({ id, error, isSelect2 = false }) => {
                const input = document.getElementById(id);
                const errorText = document.getElementById(error);

                if (!input.value.trim()) {
                    isValid = false;

                    if (isSelect2) {
                        // Tambahkan class border merah ke elemen Select2
                        const select2Elem = $(input).next('.select2-container').find('.select2-selection');
                        select2Elem.addClass("border border-red-500");
                    } else {
                        input.classList.add("border", "border-red-500");
                    }

                    errorText.classList.remove("hidden");
                } else {
                    if (isSelect2) {
                        const select2Elem = $(input).next('.select2-container').find('.select2-selection');
                        select2Elem.removeClass("border border-red-500");
                    } else {
                        input.classList.remove("border-red-500");
                    }

                    errorText.classList.add("hidden");
                }
            });

            if (!isValid) {
                e.preventDefault(); // prevent form submit if not valid
            }
        });
    });
</script>

<script>
    document.getElementById('tanggal_lahir').addEventListener('change', function () {
        const tanggal_lahir = this.value;

        if (!tanggal_lahir) {
            document.getElementById('err_tanggal_lahir').classList.remove('hidden');
            return;
        }

       const cat= document.getElementById("eve").value;
        // const ageMax = {{ $ageUpTo }};
        // Hitung umur
        const birthDate = new Date(tanggal_lahir);
        const today = new Date();
        let umur = today.getFullYear() - birthDate.getFullYear();
        const m = today.getMonth() - birthDate.getMonth();

        if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
            umur--;
        }

        // console.log('Umur:', umur);
        // console.log('Umur:', cat);

        // Ambil kategori dari server
        fetch(`/get-kategori-by-umur/${cat}/${umur}`)
            .then(response => response.json())
            .then(data => {
                // console.log('Response dari server:', data); // Tambahkan ini

                const select = document.getElementById('category');
                select.innerHTML = '<option value="">Pilih Kategori</option>';

                if (data.success && data.category.length > 0) {
                    data.category.forEach(item => {
                        // console.log('Menambahkan opsi:', item); // Tambahan log
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.participant_name;
                        select.appendChild(option);
                    });
                    // document.getElementById('warningumur').classList.add('hidden');
                } else {
                    document.getElementById('warningumur').classList.remove('hidden');
                }
            })
            .catch(error => {
                console.error('Gagal mengambil data kategori:', error);
            });


    });
</script>








        
@endsection

      
@endsection