@extends('layoutsutama.peserta')
@section('content')
        <div class="group-data-[sidebar-size=lg]:ltr:md:ml-vertical-menu group-data-[sidebar-size=lg]:rtl:md:mr-vertical-menu group-data-[sidebar-size=md]:ltr:ml-vertical-menu-md group-data-[sidebar-size=md]:rtl:mr-vertical-menu-md group-data-[sidebar-size=sm]:ltr:ml-vertical-menu-sm group-data-[sidebar-size=sm]:rtl:mr-vertical-menu-sm pt-[calc(theme('spacing.header')_*_1)] pb-[calc(theme('spacing.header')_*_0.8)] px-4 group-data-[navbar=bordered]:pt-[calc(theme('spacing.header')_*_1.3)] group-data-[navbar=hidden]:pt-0 group-data-[layout=horizontal]:mx-auto group-data-[layout=horizontal]:max-w-screen-2xl group-data-[layout=horizontal]:px-0 group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:ltr:md:ml-auto group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:rtl:md:mr-auto group-data-[layout=horizontal]:md:pt-[calc(theme('spacing.header')_*_1.6)] group-data-[layout=horizontal]:px-3 group-data-[layout=horizontal]:group-data-[navbar=hidden]:pt-[calc(theme('spacing.header')_*_0.9)]">
            <div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">
                <div class="xl:col-span-12">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-1 text-15 grow">Informasi Kontak</h6>
                            <p class="mb-4">Bukti dan konfirmasi pendaftaran akan dikirimkan ke detail informasi kontak yang tertera di sini</p>
                            <form id="applyLeave" action="{{URL::to('kirimEmail')}}" method="GET">
                                @csrf
                                <div class="grid grid-cols-1 gap-5 md:grid-cols-2 xl:grid-cols-12">
                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="full_name" class="inline-block mb-2 text-base font-medium">Nama Lengkap *</label>
                                            <input type="text" name="full_name" id="full_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('full_name') is-invalid @enderror" placeholder="Nama Lengkap Pemesan" value="{{$peserta->full_name}}" disabled>
                                            <input type="hidden" name="order_id" id="order_id" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" value="{{$kode}}">
                                            @error('full_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="email" class="inline-block mb-2 text-base font-medium">Email</label>
                                            <input type="text" name="email" id="email" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('email') is-invalid @enderror" placeholder="Email" value="{{$peserta->email}}" disabled>
                                            @error('email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="phone" class="inline-block mb-2 text-base font-medium">No. Handphone</label>
                                            <input type="text" name="phone" id="phone" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('telp') is-invalid @enderror" placeholder="Nomor aktif anda" value="{{$peserta->phone}}" disabled>
                                            @error('telp')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="md:col-span-2 xl:col-span-12">
                                        <div>
                                            <label for="alamat" class="inline-block mb-2 text-base font-medium">Alamat Lengkap</label>
                                            <textarea name="alamat" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('alamat') is-invalid @enderror " placeholder="Ketik alamat lengkap anda" rows="3" disabled>{{$peserta->alamat}}</textarea>
                                            @error('alamat')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>


                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="provinsi" class="inline-block mb-2 text-base font-medium">Provinsi</label>
                                            <input type="text" name="provinsi" id="provinsi" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('provinsi') is-invalid @enderror" value="{{$peserta->nama_prov}}" disabled>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="kabupaten" class="inline-block mb-2 text-base font-medium">Kota/Kabupaten</label>
                                            <input type="text" name="kabupaten" id="kabupaten" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('kabupaten') is-invalid @enderror" value="{{$peserta->nama}}" disabled>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="negara" class="inline-block mb-2 text-base font-medium">Warga Negara</label>
                                            <input type="text" name="negara" id="negara" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('negara') is-invalid @enderror" value="{{$peserta->country_name}}" disabled>
                                        </div>
                                    </div>
                                    <div class="xl:col-span-12">
                                    <h6 class="mb-1 text-15 grow">Detail Peserta</h6>
                                    </div>

                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="first_name" class="inline-block mb-2 text-base font-medium">Nama Depan</label>
                                            <input type="text" name="first_name" id="first_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('first_name') is-invalid @enderror" placeholder="Ketik nama depan anda" value="{{$peserta->first_name}}" disabled>
                                            @error('first_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="last_name" class="inline-block mb-2 text-base font-medium">Nama Belakang</label>
                                            <input type="text" name="last_name" id="last_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('last_name') is-invalid @enderror" placeholder="Ketik nama belakang anda" value="{{$peserta->last_name}}" disabled>
                                            @error('last_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>


                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="bib_name" class="inline-block mb-2 text-base font-medium">Nama BIB</label>
                                            <input type="text" name="bib_name" id="bib_name" maxlength = "8" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('bib_name') is-invalid @enderror" placeholder="Maksimal 8 Karakter" value="{{$peserta->bib_name}}" disabled>
                                            @error('bib_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="dokumen_id" class="inline-block mb-2 text-base font-medium">No. Kartu Identitas/No. Paspor</label>
                                            <input type="text" name="dokumen_id" id="dokumen_id" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('dokumen_id') is-invalid @enderror" placeholder="Nomor kartu identitas/ Paspor" value="{{$peserta->dokumen_id}}" disabled>
                                            @error('dokumen_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="blood_tipe" class="inline-block mb-2 text-base font-medium">Golongan Darah</label>
                                            <input type="text" name="blood_tipe" id="blood_tipe" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('blood_tipe') is-invalid @enderror" value="{{$peserta->blood_tipe}}" disabled>
                                          
                                        </div>
                                    </div>


                                    <div class="xl:col-span-12">
                                       
                                        <div>
                                            <label for="jenis_kelamin" class="inline-block mb-2 text-base font-medium">Jenis Kelamin</label>
                                            <input type="text" name="jenis_kelamin" id="jenis_kelamin" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('jenis_kelamin') is-invalid @enderror" value="{{$peserta->jenis_kelamin}}" disabled>
                                          
                                        </div>
                                    </div>



                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="tgl_lahir" class="inline-block mb-2 text-base font-medium">Tanggal Lahir</label>
                                            <input type="date" name="tgl_lahir" id="tgl_lahir" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('tgl_lahir') is-invalid @enderror" value="{{$peserta->tgl_lahir}}" disabled>
                                            @error('tgl_lahir')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                   

                                    <div class="xl:col-span-4">
                                        <div>
                                            @if($peserta->category == 1)
                                                @php
                                                 $category = 'UMUM';
                                                 @endphp
                                            @elseif($peserta->category == 2)   
                                                @php
                                                $category = 'PESERTA';
                                                @endphp
                                            @elseif($peserta->category == 3)
                                                @php
                                                $category = 'BUNDLING';
                                                @endphp
                                            @endif    
                                            <label for="category" class="inline-block mb-2 text-base font-medium">Category</label>
                                            <input type="text" name="category" id="category" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('tgl_lahir') is-invalid @enderror" value="{{$category}}" disabled>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="package" class="inline-block mb-2 text-base font-medium">Category Run</label>
                                            <input type="text" name="package" id="package" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('tgl_lahir') is-invalid @enderror" value="{{$peserta->package}}" disabled>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="price" class="inline-block mb-2 text-base font-medium">Price</label>
                                            <input type="text" name="price" id="price" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('price') is-invalid @enderror" value="{{$peserta->price}}" readonly>
                                            @error('price')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div> 

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="lokasi_run" class="inline-block mb-2 text-base font-medium">Lokasi Event</label>
                                            <input type="text" name="lokasi_run" id="lokasi_run" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" value="{{$peserta->lokasi_run}}" readonly>
                                          
                                        </div>
                                    </div>
                                    

                                   
                                    
                                    <div class="xl:col-span-12">
                                    <h6 class="mb-1 text-15 grow">Kontak Darurat</h6>
                                    <p>isi informasi kontak darurat yang dapat dihubungi</p>
                                    </div>


                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="emergency_name" class="inline-block mb-2 text-base font-medium">Nama lengkap</label>
                                            <input type="text" name="emergency_name" id="emergency_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('emergency_name') is-invalid @enderror" placeholder="Nama lengkap kontak darurat" value="{{$peserta->emergency_name}}" disabled>
                                            @error('emergency_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="telp_emergency" class="inline-block mb-2 text-base font-medium">No. Handphone</label>
                                            <input type="text" name="telp_emergency" id="telp_emergency" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('telp_emergency') is-invalid @enderror" placeholder="Nomor Aktif kontak darurat" value="{{$peserta->telp_emergency}}" disabled>
                                            @error('telp_emergency')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="relationEmergency" class="inline-block mb-2 text-base font-medium">Hubungan/Relasi</label>
                                            <input type="text" name="relationEmergency" id="relationEmergency" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('relationEmergency') is-invalid @enderror" placeholder="Keluarga/Teman/Pasangan" value="{{$peserta->relationEmergency}}" disabled>
                                            @error('relationEmergency')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
 
                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="ttd" class="inline-block mb-2 text-base font-medium">Electronic Signature</label>
                                            <input type="text" name="ttd" id="ttd" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('ttd') is-invalid @enderror" placeholder="Nama Lengkap" value="{{$peserta->ttd}}" disabled>
                                            @error('ttd')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

    
                                </div>
                                <div class="flex justify-end gap-2 mt-4">
                                    <a href="{{URL::to('/mail/send/'.$kode)}}" class="text-red-500 bg-white btn hover:text-red-500 hover:bg-red-100 focus:text-red-500 focus:bg-red-100 active:text-red-500 active:bg-red-100 dark:bg-zink-700 dark:hover:bg-red-500/10 dark:focus:bg-red-500/10 dark:active:bg-red-500/10">Edit</a>
                                    <button type="submit" id="lanjut" class="text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">Simpan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
               
            </div>
        </div>    


             <!-- Size Chart-->
             <div id="addSizeCart" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
                <div class="w-screen md:w-[40rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Size Chart</h5>
                    <button data-modal-close="addSizeCart" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        <!-- <div class="grid grid-cols-1 gap-4 xl:grid-cols-12"> -->
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                              
                                <div class="p-2 text-center">
                                    <img src="assets/size/size_chart.PNG" alt="size" >
                                    
                                </div>
                                
                                
                            </div>
                        </div>

                    
                        
                        <!-- </div> -->
                
                </div>
                </div>
            </div>
            <!--end Size Chart-->

                <!-- Size Chart-->
             <div id="aturanERJF" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
                <div class="w-screen md:w-[40rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Aturan dan Ketentuan EJRF 2025</h5>
                    <button data-modal-close="aturanERJF" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                              
                                <div class="p-2 text-center">
                                    <p>isi aturan</p>
                                    
                                </div>
                                
                                
                            </div>
                        </div>

                    
                        
                        <!-- </div> -->
                
                </div>
                </div>
            </div>
            <!--end Size Chart-->

@section('script')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
        $(document).ready(function() {
            // Set tombol button disabled berdasarkan status checkbox
            $('#checkboxDefault').change(function() {
                if ($(this).is(':checked')) {
                    $('#lanjut').prop('disabled', false); // Menonaktifkan tombol jika checkbox dicentang
                } else {
                    $('#lanjut').prop('disabled', true); // Mengaktifkan tombol jika checkbox tidak dicentang
                }
            });
        });
</script>


@endsection
@endsection