<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();         // ID user yang melakukan aksi
            $table->string('action');                      // create, update, delete
            $table->string('model');                       // Nama model (Kategori Event, dsb)
            $table->unsignedBigInteger('model_id')->nullable(); // ID data yang dimanipulasi
            $table->text('description')->nullable();       // Keterangan tambahan
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
