<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ticket_company', function (Blueprint $table) {
            $table->string('ticket_id',5)->primary();
            $table->string('event_id',10);
            $table->string('ticket_name',20);
            $table->tinyInteger('jersey');
            $table->intger('category_event_id',5);
            $table->tinyInteger('category_ticket_id');
            $table->boolean('enable_kuota_ticket');
            $table->unsignedInteger('kuota_ticket'); // kuota, tidak negatif
            $table->unsignedInteger('price'); // harga, tidak negatif
            $table->date('start_date');
            $table->date('end_date');
            $table->unsignedInteger('age_of'); 
            $table->unsignedInteger('age_up_to'); 
            $table->boolean('active_ticket_company');
            $table->string('category_participant_id'); 
            $table->timestamps();  
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         Schema::dropIfExists('ticket_company');
    }
};
