<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use App\Models\company_event;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Inject $event_id ke sidebar
         $id = request()->route('id'); 
        View::composer('sidebar.sidebar', function ($view) {
            $event_id = $id ?? company_event::latest()->value('event_id'); 
            $view->with('event_id', $event_id);
        });
    }
}
