<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Session;

class ActivityLog extends Model
{
    protected $fillable = [
        'user_id',
        'action',
        'model',
        'model_id',
        'description'
    ];
    public static function createLog($action, $model, $modelId = null, $description = null)
    {
        self::create([
            'user_id'    => auth()->user()->name,    // Ambil ID user login
            'action'     => $action,
            'model'      => $model,
            'model_id'   => $modelId,
            'description'=> $description,
        ]);

       
    }
}
