<?php

namespace App\Livewire;

use App\Models\Peserta;
use Livewire\Component;

class RaceParticipant extends Component
{

    public $lok;
    public $peserta;

    protected $listeners = ['refreshData' => '$refresh'];

    public function mount($lok)
    {
        $this->lok = $lok;
        $this->peserta = Peserta::where('loket', $lok)->get(); // Sesuaikan dengan query untuk mendapatkan data
    }
    public function render()
    {
        return view('livewire.race-participant');
    }

    public function refreshData()
    {
        $this->peserta = Peserta::where('loket', $this->lok)->get();
    }
}
