<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckModulePermission
{
    public function handle(Request $request, Closure $next, $module, $permission)
    {
        $user = auth()->user();

                // Ambil nama kota dari module, contoh: 'kediri', 'madiun', 'surabaya'
                $city = strtolower($module); // pastikan module yang dikirim = nama kota

                $now = Carbon::now()->format('Y-m-d');
        
                // Cek rentang tanggal tiket untuk kota tersebut
                $availableTicket = Ticket::whereDate("tgl_tiket_mulai_{$city}", '<=', $now)
                    ->whereDate("tgl_tiket_selesai_{$city}", '>=', $now)
                    ->first();
        
                if (!$availableTicket) {
                    return response()->view('closed', [], 404);
                }

        return $next($request);
    }
}
