<?php

namespace App\Http\Controllers;

use DB;
use run;
use App\Models\Tiket;
use App\Models\Voucer;
use App\Models\HargaTiket;
use App\Models\Lokasi_run;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\KategoryEvent;
use App\Models\Kategori_peserta;
use Brian2694\Toastr\Facades\Toastr;

class TiketController extends Controller
{
    public function tiketList()
    {
        $tik = Tiket::where('status_tiket',1)->get();
        $tikall = Tiket::all();
        return view('settingski.tiket', compact('tik','tikall'));
    }

    public function saveRecordtiket(Request $request)
    {
     
            $request->validate([

                    'nama_tiket' => 'required|string',
                    'tgl_tiket_mulai'=>'required',
                    'tgl_tiket_selesai' => 'required',
                   
                ]);
        
                try {
                     
                        // Create a new product instance and populate fields
                        $id_tik = Str::random(5);
                        $tiket = new Tiket();
                        $tiket->fill([
                            'id_tiket'         => $id_tik,
                            'nama_tiket'        => Str::upper($request->nama_tiket),
                            'promo' => $request->promo,   
                            'tgl_tiket_mulai'     => $request->tgl_tiket_mulai,
                            'tgl_tiket_selesai'   => $request->tgl_tiket_selesai,
                            'status_tiket' => 1,
                            
                        ]);
                        $tiket->save();

                    Toastr::success('Tiket Berhasil dibuat', 'Success');
                    return redirect('tiket/list');
                } catch (\Exception $e) {
                    \Log::error($e);
                    Toastr::error('Tiket Gagal dibuat', 'Error');
                    return $e;
                }
          

    }

    public function tiketUpdateRecord(Request $request)
    {
       
        try {

            $tiket                    = Tiket::findOrFail($request->id_tiket);

            $tiket->update([
                $tiket->nama_tiket            = Str::upper($request->nama_tiket),
                $tiket->promo                = $request->promo,
                $tiket->tgl_tiket_mulai       = $request->tgl_tiket_mulai,
                $tiket->tgl_tiket_selesai  = $request->tgl_tiket_selesai,
                $tiket->tgl_tiket_mulai_kediri       = $request->tgl_tiket_mulai_kediri,
                $tiket->tgl_tiket_selesai_kediri  = $request->tgl_tiket_selesai_kediri,
                $tiket->tgl_tiket_mulai_madiun       = $request->tgl_tiket_mulai_madiun,
                $tiket->tgl_tiket_selesai_madiun  = $request->tgl_tiket_selesai_madiun,
                $tiket->tgl_tiket_mulai_surabaya       = $request->tgl_tiket_mulai_surabaya,
                $tiket->tgl_tiket_selesai_surabaya  = $request->tgl_tiket_selesai_surabaya,
               
                
            ]);

            Toastr::success('updated sukses','Success');
            return redirect('tiket/list');
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function tiketDeleteRecord(Request $request) 
    {
        try {
            // Find the tiket record or fail if not found
            $syarat = Tiket::findOrFail($request->id_delete);
            $syarat->status_tiket = 0; 
            $syarat->update();

            
            Toastr::success('Syarat Bayar Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Syart Bayar Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // harga tiket evnet
    public function hargaTiketlist()
    {
        $harga = DB::table('harga_tiket')
                ->join('tiket', 'harga_tiket.tiket_id', '=', 'tiket.id_tiket')
                ->join('kat_event','harga_tiket.category_event_id','=','kat_event.id_kat_event')
                ->orderBy('tiket.nama_tiket','desc')
                ->get();
        $tik = Tiket::where('status_tiket',1)->get();     
        $kat_e = KategoryEvent::where('active_kat_event',1)->get();   
        return view('settingski.hargatiket', compact('harga','tik','kat_e'));
    }

    public function saveRecordharga(Request $request)
    {
        $request->validate([

                'tiket_id' => 'required|string',
                'category_event_id' => 'required|string',
                'harga_tiket'=>'required',
                'keterangan_tiket'=>'required',
            ]);
    
            try {
                    // Create a new product instance and populate fields
                    $id_harga = Str::random(5);
                    $hrg = new HargaTiket();
                    $hrg->fill([
                        'id_harga'         => $id_harga,
                        'tiket_id'        =>$request->tiket_id,
                        'category_event_id' => $request->category_event_id,
                        'harga_tiket' => Str::upper($request->harga_tiket),   
                        'keterangan_tiket'     => $request->keterangan_tiket,
                        'active_harga_tiket'=> 1,
                        
                    ]);
                    $hrg->save();

                Toastr::success('Harga Tiket Berhasil dibuat', 'Success');
                return redirect('tiket/listHarga');
            } catch (\Exception $e) {
                \Log::error($e);
                Toastr::error('Harga Tiket Gagal dibuat', 'Error');
                return $e;
            }
      

    }

    public function tiketHargaUpdateRecord(Request $request)
    {
       
        try {

            $Htiket                    = HargaTiket::findOrFail($request->id_harga);

            $Htiket->update([
                $Htiket->tiket_id            = $request->tiket_id,
                $Htiket->category_event_id   = $request->category_event_id,
                $Htiket->harga_tiket       = $request->harga_tiket,
                $Htiket->keterangan_tiket  = $request->keterangan_tiket,
                $Htiket->active_harga_tiket  = $request->active_harga_tiket,

            ]);

            Toastr::success('updated sukses','Success');
            return redirect('tiket/listHarga');
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }
    // end harga tiket event

    
    // kategori event
    public function kategoryRunList()
    {
        $category = KategoryEvent::where('active_kat_event',1)->get();
        return view('settingski.kategorirun', compact('category'));
    }

    public function saveRecordkategorirun(Request $request)
    {
        $request->validate([

                'nama_kat_event' => 'required|string',
        
            ]);
    
            try {
                    // Create a new product instance and populate fields
                    $id_ke = Str::random(5);
                    $ke = new KategoryEvent();
                    $ke->fill([
                        'id_kat_event'         => $id_ke,
                        'nama_kat_event'        =>Str::upper($request->nama_kat_event),
                        'active_kat_event' => 1,   
                        
                    ]);
                    $ke->save();

                Toastr::success('Kategori Event Berhasil dibuat', 'Success');
                return redirect('tiket/kategorirunlist');
            } catch (\Exception $e) {
                \Log::error($e);
                Toastr::error('Kategori Event Gagal dibuat', 'Error');
                return $e;
            }
      

    }

    public function kategorirunUpdateRecord(Request $request)
    {
        
        
      
        try {
    
          $ke  = KategoryEvent::findOrFail($request->id_kat_event);
    
            $ke->update([
                $ke->nama_kat_event  = Str::upper($request->nama_kat_event),
            ]);
    
            Toastr::success('updated sukses','Success');
            return redirect('tiket/kategorirunlist');
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function kategorirunDeleteRecord(Request $request)
    {
        try {
            // Find the holiday record or fail if not found
            $syarat = KategoryEvent::findOrFail($request->id_delete);
            $syarat->active_kat_event = 0; 
            $syarat->update();

            
            Toastr::success('Category Event Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Category Event Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }
    // end kategori event

    // lokasi event
    public function lokasiList()
    {
        $lok = Lokasi_run::where('active_lokasi_run',1)->get();
        return view('settingski.lokasi_run', compact('lok'));
    }

    public function saveRecordlokasi(Request $request)
    {
        $request->validate([

                'lokasi' => 'required|string',
        
            ]);
    
            try {
                    // Create a new lokasi fields
                    $id_lok = Str::random(5);
                    $lok = new Lokasi_run();
                    $lok->fill([
                        'kode_lokasi'         => $id_lok,
                        'lokasi'        =>Str::title($request->lokasi),
                        'target_peserta' => $request->target_peserta,
                        'target_peserta_presale' => $request->target_peserta_presale,
                        'tiket_buka' => $request->tiket_buka,
                        'tiket_tutup' => $request->tiket_tutup, 
                        'active_lokasi_run' => 1,  
                        
                    ]);
                    $lok->save();

                Toastr::success('Lokasi Event Berhasil dibuat', 'Success');
                return redirect('tiket/listLokasi');
            } catch (\Exception $e) {
                \Log::error($e);
                Toastr::error('Lokasi Event Gagal dibuat', 'Error');
                return $e;
            }
      

    }

    public function lokasiUpdateRecord(Request $request)
    {

        try {
    
          $ke  = Lokasi_run::findOrFail($request->kode_lokasi);
    
            $ke->update([
                $ke->lokasi  = Str::title($request->lokasi),
                $ke->target_peserta  = $request->target_peserta,
                $ke->target_peserta_presale  = $request->target_peserta_presale,
                $ke->tiket_buka  = $request->tiket_buka,
                $ke->tiket_tutup  = $request->tiket_tutup,
            ]);
    
            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function lokasiDeleteRecord(Request $request)
    {
        try {
            // Find the holiday record or fail if not found
            $syarat = Lokasi_run::findOrFail($request->id_delete);
            $syarat->active_lokasi_run = 0; 
            $syarat->update();

            
            Toastr::success('Category Event Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Category Event Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // end lokasi event

    // kategori peserta
    public function kategoriPeserta()
    {
        $ktp = Kategori_peserta::where('active_idp',1)->get();
        return view('settingski.kategori_peserta', compact('ktp'));
    }

    public function saveRecordkategoriPeserta(Request $request)
    {
        $request->validate([

                'nama_kategori' => 'required|string',
        
            ]);
    
            try {
                    // Create a new lokasi fields
                   
                    $lok = new Kategori_peserta();
                    $lok->fill([
                    
                        'nama_kategori'        =>Str::title($request->nama_kategori),
                        'katerangan_kp' => $request->katerangan_kp,
                        'extra_quota' => $request->extra_quota,
                        'war_tiket' => $request->war_tiket,
                        'active_idp' => 1,  
                        
                    ]);
                    $lok->save();

                Toastr::success('Kategori Peserta Berhasil dibuat', 'Success');
                return redirect('kategori/peserta');
            } catch (\Exception $e) {
                \Log::error($e);
                Toastr::error('Kategori Peserta Gagal dibuat', 'Error');
                return $e;
            }
      

    }

    public function kategoriPesertaUpdateRecord(Request $request)
    {

        try {
    
          $ke  = Kategori_peserta::findOrFail($request->kategori_idp);
    
            $ke->update([
                $ke->nama_kategori  = Str::title($request->nama_kategori),
                $ke->katerangan_kp  = $request->katerangan_kp,
                $ke->extra_quota  = $request->extra_quota,
                $ke->war_tiket  = $request->war_tiket,
            
            ]);
    
            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function kategoriPesertaDeleteRecord(Request $request)
    {
        try {
            // Find the holiday record or fail if not found
            $syarat = Kategori_peserta::findOrFail($request->id_delete);
            $syarat->active_idp = 0; 
            $syarat->update();

            
            Toastr::success('Kategori Peserta Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Kategori Peserta Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // end kategori peserta

    public function voucer()
    {
        $lokasi = Lokasi_run::all();
        $voc = DB::table('voucer')
                // ->join('tiket', 'harga_tiket.tiket_id', '=', 'tiket.id_tiket')
                ->join('lokasi_run','voucer.kota_voucer','=','lokasi_run.kode_lokasi')
                ->get();
        return view('settingski.voucer',compact('voc','lokasi'));
    } 
    // $request->validate([
           
    //     'kode_gudang'    => 'required|string',
    //     'nama_gudang' => 'required|string',
      
    // ]);

    // try {
    //     $pm = Warehouse::updateOrCreate(
    //         ['id_gudang' => $request->id_gudang],
    //         [
    //             'kode_gudang' => Str::upper($request->kode_gudang),
    //             'nama_gudang'  => Str::upper($request->nama_gudang),
    //             'aktif' => 1,
                
    //         ]
    //     );
       
    //     Toastr::success('Gudang Berhasil dibuat', 'Success');
    //     return redirect()->back();
    // } catch (\Exception $e) {
    //     \Log::error($e);
    //     Toastr::error('Gudang Gagal dibuat', 'Error');
    //     return $e;
    // }

    public function saveRecordvoucer(Request $request)
    {
     
            $request->validate([

                    'nama_voucer' => 'required|string',
                    'anggota'=>'required',
                    'diskon' => 'required',
                   
                ]);
        
                try {
                     
                        // Create a new product instance and populate fields
                        $kode = Str::random(8);
                        $pm = Voucer::updateOrCreate(
                                    ['kode_voucer' => $kode],
                                    [
                                     
                                        'kota_voucer' => $request->kota_voucer,
                                        'nama_voucer' => Str::upper($request->nama_voucer),
                                        'anggota'  => $request->anggota,
                                        'diskon' => $request->diskon,
                                        
                                    ]
                                );
                   
                      

                    Toastr::success('Voucer Berhasil dibuat', 'Success');
                    return redirect()->back();
                } catch (\Exception $e) {
                    \Log::error($e);
                    Toastr::error('Voucer Gagal dibuat', 'Error');
                    return $e;
                }
          

    }


}
