<?php

namespace App\Http\Controllers;

use App\Models\Peserta;
use App\Models\Lokasi_run;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function reportList()
    {
        $pes = Peserta::whereIn('lokasi_run',['BW','AL','AL2'])->get();
        $t_all = $pes->count();
        $p = $pes->where('pembayaran','Paid')->count();
        $exp = $pes->where('pembayaran','Pending')->count();
        $tar_bw = Lokasi_run::where('kode_lokasi','BW')->get();
        $persen = ($p/$tar_bw[0]->target_peserta)*100;
        $fivek = $pes->where('pembayaran','Paid')->whereIn('package',['KBch0'])->count();
        $fivbund3 = $pes->where('pembayaran','Paid')->where('price',630000)->count(); 
        $fivbund4 = $pes->where('pembayaran','Paid')->where('price',865000)->count(); 
        
        $tenk = $pes->where('pembayaran','Paid')->whereIn('package',['q72VN'])->count(); 
        $tenbund3 = $pes->where('pembayaran','Paid')->where('price',780000)->count(); 
        $tenbund4 = $pes->where('pembayaran','Paid')->where('price',1000000)->count(); 
       
        $fun = $pes->where('pembayaran','Paid')->where('package','ELyx4')->count(); 

        $u = $pes->where('pembayaran','Paid')->where('category','1')->count();
        $px = $pes->where('pembayaran','Paid')->where('category','2')->count();
        $b = $pes->where('pembayaran','Paid')->where('category','3')->count();
        $e = $pes->where('pembayaran','Paid')->where('category','4')->count();
        $m = $pes->where('pembayaran','Paid')->where('category','5')->count();

        $results = Peserta::selectRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END AS k,
            COUNT(*) as j
        ')
        ->whereIn('lokasi_run',['BW','AL','AL2'])
        ->where('pembayaran','Paid')
        ->where('category','1')
        ->groupByRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END
        ')
        ->get();

        $resultsP = Peserta::selectRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END AS k,
            COUNT(*) as j
            ')
        ->whereIn('lokasi_run',['BW','AL','AL2'])
        ->where('pembayaran','Paid')
        ->where('category','2')
        ->groupByRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END
            ')
        ->get();

        $resultsM = Peserta::selectRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END AS k,
            COUNT(*) as j
            ')
        ->whereIn('lokasi_run',['BW','AL','AL2'])
        ->where('pembayaran','Paid')
        ->where('category','5')
        ->groupByRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END
            ')
        ->get();

        

        $resultsE = Peserta::selectRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END AS k,
            COUNT(*) as j
            ')
        ->whereIn('lokasi_run',['BW','AL','AL2'])
        ->where('pembayaran','Paid')
        ->where('category','4')
        ->groupByRaw('
            CASE 
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) < 18 THEN "A"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) BETWEEN 18 AND 44 THEN "B"
                WHEN TIMESTAMPDIFF(YEAR, tgl_lahir, updated_at) > 44 THEN "C"
            END
            ')
        ->get();

        //size pria
        $xs = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','XS')->count();
        $s = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','S')->count();  
        $m = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','M')->count();                                
        $l = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','L')->count();  
        $xl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','XL')->count(); 
        $xxl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','2XL')->count(); 
        
        $xxxl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','3XL')->count();   
        $xxxxl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','pria')
                        ->where('tshirt_size','4XL')->count();  
                        
        //wanita
        $wxxs = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','2XS')->count();
        $wxs = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','XS')->count();
        $ws = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','S')->count();  
        $wm = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','M')->count();                                
        $wl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','L')->count();  
        $wxl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','XL')->count(); 
        $wxxl = peserta::where('pembayaran','paid')
                        ->whereIn('lokasi_run',['BW','AL','AL2'])
                        ->where('jenis_kelamin','Wanita')
                        ->where('tshirt_size','2XL')->count(); 
                         



        return view('report.list', compact('pes','t_all','p','exp','tar_bw','persen','fivek','tenk','fivbund3','fivbund4','tenbund3','tenbund4','fun','u','px','b','e','m','results','resultsP','resultsM','resultsE','xs','s','m','l','xl','xxl','xxxl','xxxxl','wxxs','wxs','ws','wm','wl','wxl','wxxl'));
    }

}
