<?php

namespace App\Http\Controllers;

use App\Models\Peserta;
use Illuminate\Http\Request;
use App\Services\ParticipantService;

class ParticipantController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'category' => 'required|string',
            'gender' => 'required|in:pria,wanita',
            'run_category' => 'required|integer'
        ]);

        try {
            $serialNumber = ParticipantService::generateSerialNumber(
                $request->category,
                $request->gender,
                $request->run_category
            );

            $participant = Peserta::create([
                'category' => $request->category,
                'gender' => $request->gender,
                'run_category' => $request->run_category,
                'serial_number' => $serialNumber,
            ]);

            return response()->json(['message' => 'Bib Number berhasil di generate', 'data' => $participant], 201);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 400);
        }
    }
}
