<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Imports\PesertaBibImport;
use Maatwebsite\Excel\Facades\Excel;

class ImportBibController extends Controller
{
    //

    public function import(Request $request)
    {
        // Validasi file yang diupload
        $request->validate([
            'file' => 'required|mimes:xlsx,csv',
        ]);

        // Proses import
        $file = $request->file('file');
        
        // Import menggunakan class UsersImport
        Excel::import(new PesertaBibImport, $file);

        return redirect()->back()->with('success', 'Data berhasil diimport dan diupdate.');
    }

}
