<?php

namespace App\Http\Controllers;

use DB;
use App\Models\Coa;
use App\Models\running_company;
use App\Models\company_event;
use App\Models\Lokasi_run;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function homeMain($comp,$id)
    {
        $ps = DB::table('peserta')
               ->where('lokasi_run',$id)
                ->get();
        $t_ps = $ps->count();
        $paid = $ps->where('pembayaran','Paid')->count();
        $exp = $ps->where('pembayaran','Failed')->count();
        
      
        
        session(['current_event_id' => $id]);
        session(['current_company_id' => $comp]);
   
        $comp_ev = company_event::where('event_id',$id)->get();
        $name_comp = running_company::where('company_id',$comp)->value('company_name');        

        //jika enable_kuota_ticket = 0 maka nilai kuota_ticket default (1000)
        $total = DB::table('ticket_company')
            ->select('event_id', DB::raw("
                SUM(CASE 
                        WHEN enable_kuota_ticket = 0 OR kuota_ticket IS NULL THEN 1000
                        ELSE kuota_ticket
                    END) AS total_kuota
            "))
            ->where('event_id',$id)
            ->groupBy('event_id')
            ->get();
        $target = isset($total[0]) ? $total[0]->total_kuota : 0;
        $tr_bw = $target ? ($paid / $target) * 100 : 0;

        return view('dashboard.home',compact('name_comp','total','comp_ev','t_ps','paid','exp','tr_bw'));
    }

    public function index()
    {
        $depart = Session::get('department');
        $userId = Session::get('role_name');
        $event1 = running_company::where('active_company',1)->get();
        $event2 = running_company::where('active_company',1)->where('company_id',$depart)->get();
        $events = ($userId == 'Admin' or $userId == 'Loket') ? $event1 : $event2;
        return view('dashboard.homeRun',compact('events'));
    }

    public function event($id)
    {
        $events = company_event::where('company_id',$id)->where('active_company_event',1)->get();
        // session(['current_event_id' => $id]);
        session(['current_company_id' => $id]);
        $cop = $id;
        $name_comp = running_company::where('company_id',$id)->value('company_name');        
        
        return view('dashboard.homeEvent',compact('events','cop','name_comp'));
    }


}
