<?php

namespace App\Http\Controllers;

use DB;
use App\Models\ic;
use Carbon\Carbon; 
use App\Models\blood;
use App\Models\gender;
use App\Models\Country;
use App\Models\peserta;
use App\Models\ticket_company;
use App\Models\participant_company_event;
use App\Models\company_event;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use App\Models\participant;
use App\Models\size_jersey;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class EventController extends Controller
{
    public function showTickets($event_id)
    {
        $tickets = DB::table('company_event')
                    ->join('running_company','company_event.company_id','=','running_company.company_id')
                    ->where('event_id', $event_id)
                    ->get();
        $price =  DB::table('ticket_company')
                    ->join('category_ticket','ticket_company.category_ticket_id','=','category_ticket.id')
                    ->where('event_id',$event_id)
                    ->orderBy('price', 'asc')
                    ->get();
       
       
    
        if (!empty($price) && isset($price[0]->category_participant_id)) {
            $ids = json_decode($price[0]->category_participant_id, true) ?? [];
            $cp = !empty($ids) ? participant::whereIn('id', $ids)->get() : collect();
        } else {
            $cp = collect(); // hasil kosong kalau $price kosong
        }       
        
        $priceWithParticipants = $price->map(function ($priceItem) {
            $ids = json_decode($priceItem->category_participant_id, true) ?? [];
           
             // Pastikan array
            if (!is_array($ids)) {
                $ids = [];
            }

            $participants = !empty($ids) ? participant::whereIn('id', $ids)->get()  : collect();
            $priceItem->participants = $participants;
        

            $peser = peserta::where('lokasi_run',$priceItem->event_id)->where('package',$priceItem->ticket_name)->where('pembayaran','Paid')->count();
            $priceItem->peserta_count = $peser;

            return $priceItem;
            
            
        });
    //   dd($priceWithParticipants);
        return view('home.event', compact('tickets','price','cp','priceWithParticipants'));
    }

    public function register($tiket)
    {
        

        $tik = DB::table('ticket_company')
                ->join('kategori_event','ticket_company.category_event_id','=','kategori_event.id')
                ->join('category_ticket','ticket_company.category_ticket_id','=','category_ticket.id')
                ->join('company_event','ticket_company.event_id','=','company_event.event_id')
                ->where('ticket_id', $tiket)
                ->get();
             

        if ($tik->isEmpty()) {
            abort(404); // Tiket tidak ditemukan
        }

        // Ambil tanggal hari ini
        $today = Carbon::today();

        // Cek apakah tanggal hari ini valid dalam rentang event
        $startDate = Carbon::parse($tik[0]->start_date);
        $endDate = Carbon::parse($tik[0]->end_date);


        if ($today->lt(Carbon::parse($startDate))) {
            // return response()->view('errors.register_closed', ['message' => 'Pendaftaran belum dibuka.']);
            abort(403, 'Pendaftaran belum dibuka.');
        }

        if ($today->gt(Carbon::parse($endDate))) {
            // return response()->view('errors.register_closed', ['message' => 'Pendaftaran sudah ditutup.']);
            abort(403, 'Pendaftaran sudah di tutup.');
        }

        $quota = peserta::where('pembayaran','Paid')
                        ->where('package',$tik[0]->ticket_name)
                        ->where('lokasi_run',$tik[0]->event_id)
                        ->count();
                     
        if ($quota >= $tik[0]->kuota_ticket) {
            abort(403, 'Kuota Penuh.');
        }
              
        
        $trs = Str::random(7).date('ym');
        $nik = ic::where('active_ic',1)->get();      
        $bld = blood::where('active_blood',1)->get(); 
        $gndr = gender::where('active_gender',1)->get();
        $cntry = Country::all();
        $prvinsi = Provinsi::all();
        $kab = Kabupaten::all();
        $ket = $tik[0]->event_id;
        $eve = $tik[0]->ticket_id;

        $cs_sz = size_jersey::where('company_event_id',$ket)->orderBy('size', 'asc')->get();
        $def_sz = size_jersey::where('company_event_id','def')->orderBy('size', 'asc')->get();
        
        $tc = ticket_company::where('ticket_id',$tiket)->value('jersey');
        $sz = ($tc == 0) ? $def_sz : $cs_sz;

        $ageMin = participant_company_event::where('ticket_id', $tiket)
                ->min('age_of');
        
        $ageMax = participant_company_event::where('ticket_id', $tiket)
                ->max('age_up_to');

      
        return view('home.register', compact('ageMax','ageMin','eve','tik','sz','ket','trs','nik','bld','gndr','cntry','prvinsi','kab'));

    }

    public function preview($tiket)
    {
        $prev = peserta::join('participant','peserta.category','=','participant.id')
                        ->join('company_event','peserta.lokasi_run','=','company_event.event_id')
                        ->where('order_id',$tiket)->get();
        return view('home.ringkasan', compact('prev'));
    }

    public function getKategoriByUmur($cat,$umur)
    {
        $eventId = $cat; // Sesuaikan sesuai kebutuhan
        $cek_kuota =  participant_company_event::where('ticket_id',$eventId)->where('participant_id',1)->value('quota_participant_event');
//         $ticktRaw = ticket_company::where('event_id', $eventId)
//     ->where('ticket_name', '10K')
//     ->value('category_participant_id');

// if (is_string($ticktRaw)) {
//     // Kalau string JSON seperti ["1","2","3"], decode
//     $ticketIds = json_decode($ticktRaw, true) ?? [];
// } elseif (is_array($ticktRaw)) {
//     // Kalau sudah array langsung pakai
//     $ticketIds = $ticktRaw;
// } else {
//     // Kalau null atau bukan tipe yang diharapkan
//     $ticketIds = [];
// }

        $kategori = DB::table('participant_company_event')
            ->select('participant_id as id', 'participant_name')
            ->where('ticket_id', $eventId)
            ->where('age_of', '<=', $umur)
            ->where('age_up_to', '>=', $umur)
            ->get();

        \Log::info("Kuota :".$cek_kuota);
        // \Log::info("Kuota :".$ticketIds);
        // \Log::info("Kategori ditemukan: " . $kategori->count());

        if ($kategori->isNotEmpty()) {
            return response()->json([
                'success' => true,
                'category' => $kategori
            ]);
        } else {
            return response()->json(['success' => false]);
        }
    }

    public function showPeserta($event_id)
    {
        $peserta = DB::table('peserta')
                    ->join('participant','peserta.category','=','participant.id')
                    ->join('provinsi','peserta.provinsi','=','provinsi.id_prov')
                    ->join('country_data2','peserta.negara','=','country_data2.id_country')
                    ->where('lokasi_run',$event_id)
                    ->get();
        $nama = company_event::where('event_id',$event_id)->value('event_name');            
        return view('home.peserta', compact('peserta','nama'));        
    }


}
