<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\company_event;
use Carbon\Carbon;
use Session;
use DB;
use Hash;
use Brian2694\Toastr\Facades\Toastr;

class AccountController extends Controller
{
    /** page account profile */
    public function profileDetail($user_id)
    {
        $profileDetail = User::where('user_id', $user_id)
                        ->join('running_company','users.department','=','running_company.company_id')
                        ->first();
        // dd($profileDetail);
        // $profileDetail = $profileDetail2 ?? NULL;                
        $tot1 = company_event::where('company_id', $profileDetail->company_id ?? 0)->count();
        $tot = $tot1 ?? 0;
       
        return view('pages.account-profile', compact('profileDetail','tot'));
    }

    public function accountList()
    {

        $accountList = User::all();
        $roles = DB::table('role_type_users')->get();
        return view('pages.account-list', compact('accountList','roles'));
    }

    public function accountSaveRecord(Request $request)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
        ]);

        try {
            $register = new User();
            $register->name      = $request->name;
            $register->email     = $request->email;
            $register->join_date = Carbon::now()->toDayDateTimeString();
            $register->role_name = $request->role;
            $register->status    = 'Active';
            $register->password  = Hash::make($request->password);
            $register->save();

            Toastr::success('Akun Berhasil Dibuat', 'Success');
            return redirect('page/account/list');
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Akun gagal Dibuat', 'Error');
            return redirect()->back();
        }
    }

    public function accountEditRecord(Request $request)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users',
            
        ]);
        try {


   
            $userUpdate = User::updateOrCreate(
                ['user_id' => $request->user_id],
                [
                    'name' => $request->name,
                    'email' => $request->email,
                    'status' => $request->status,
                    'role_name'  => $request->role,
                ]
            );
           
            Toastr::success('User Berhasil diupdate', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('User Gagal diupdate', 'Error');
            return $e;
        }
    }
}
