<?php

namespace App\Exports;

use DB;
use App\Models\Peserta;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PesertaExport implements FromCollection, WithHeadings, WithMapping, WithColumnFormatting
{
    protected $lokasiId;

    public function __construct($lokasiId)
    {
        $this->lokasiId = $lokasiId;
    }

    public function collection()
    {
        return DB::table('peserta')
                ->join('kabupatens','peserta.kabupaten','=','kabupatens.id')
                ->join('participant','peserta.category','=','participant.id')
                ->join('country_data2','peserta.negara','=','country_data2.id_country')
                ->join('company_event','peserta.lokasi_run','=','company_event.event_id')
                // ->where('pembayaran', 'Paid')
                ->where('lokasi_run', $this->lokasiId)
                ->get([
                    "bib_number", "order_id", "full_name", "first_name", "last_name",
                    "email", "phone", "bib_name", "dokumen_id", "blood_tipe", "jenis_kelamin",
                    "tgl_lahir", "tshirt_size", "community", "emergency_name", "telp_emergency",
                    "relationEmergency", "package", "address_event", "alamat", "nama",
                    "country_name", "voucher", "pembayaran", "price", "participant_name"
                ]);
    }

    public function headings(): array
    {
        return [
            "bibNumber", "orderId", "fullName", "firstName", "lastName", "email",
            "phone", "bibName", "documentId", "bloodType", "sex", "dob",
            "tShirtSize", "community", "nameEmergency", "phoneEmergency",
            "relationEmergency", "category", "lokasi", "address", "name",
            "nationality", "voucherCode", "pay", "nominal", "Category"
        ];
    }

    public function map($peserta): array
    {
        return [
            $peserta->bib_number,
            $peserta->order_id,
            $peserta->full_name,
            $peserta->first_name,
            $peserta->last_name,
            $peserta->email,
            $peserta->phone,
            $peserta->bib_name,
            "`" . strval($peserta->dokumen_id), // Paksa jadi string dengan apostrof di awal
            $peserta->blood_tipe,
            $peserta->jenis_kelamin,
            $peserta->tgl_lahir,
            $peserta->tshirt_size,
            $peserta->community,
            $peserta->emergency_name,
            $peserta->telp_emergency,
            $peserta->relationEmergency,
            $peserta->package,
            $peserta->address_event,
            $peserta->alamat,
            $peserta->nama,
            $peserta->country_name,
            $peserta->voucher,
            $peserta->pembayaran,
            $peserta->price,
            $peserta->participant_name,
        ];
    }

    public function columnFormats(): array
    {
        return [
            'I' => NumberFormat::FORMAT_TEXT, // Kolom I (dokumen_id) diformat sebagai teks
        ];
    }
}
